/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.mapui;

import filenet.vw.api.IVWPastable;
import filenet.vw.api.VWAssociationDefinition;
import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWCompoundStepDefinition;
import filenet.vw.api.VWException;
import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWRouteDefinition;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.api.VWTextAnnotationDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.mapui.VWDesignerDraggedAssociationUI;
import filenet.vw.toolkit.design.mapui.VWDesignerDraggedRouteUI;
import filenet.vw.toolkit.design.mapui.VWDesignerWorkflowPane;
import filenet.vw.toolkit.design.mapui.resources.VWResource;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.utils.VWPopupMenu;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWStepUtils;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeListener;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeSource;
import filenet.vw.toolkit.utils.event.VWPropertyChangeEvent;
import filenet.vw.toolkit.utils.mapui.IVWSelectWorkflowItem;
import filenet.vw.toolkit.utils.mapui.VWBaseAssociationUI;
import filenet.vw.toolkit.utils.mapui.VWBaseRouteUI;
import filenet.vw.toolkit.utils.mapui.VWBaseStepUI;
import filenet.vw.toolkit.utils.mapui.VWBaseTextAnnotationUI;
import filenet.vw.toolkit.utils.mapui.VWBaseWorkflowMapPane;
import filenet.vw.toolkit.utils.mapui.VWComponentStepUI;
import filenet.vw.toolkit.utils.mapui.VWGeneralStepUI;
import filenet.vw.toolkit.utils.mapui.VWLaunchStepUI;
import filenet.vw.toolkit.utils.mapui.VWMap;
import filenet.vw.toolkit.utils.mapui.VWMapCache;
import filenet.vw.toolkit.utils.mapui.VWMapNodeUIToolkit;
import filenet.vw.toolkit.utils.mapui.VWRouteBubbleRenderer;
import filenet.vw.toolkit.utils.mapui.VWStepRouteColors;
import filenet.vw.toolkit.utils.mapui.VWSubmapStepUI;
import filenet.vw.toolkit.utils.mapui.VWSystemStepUI;
import filenet.vw.toolkit.utils.table.VWColorListCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.TooManyListenersException;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JViewport;

public class VWDesignerWorkflowMapPane
extends VWBaseWorkflowMapPane
implements MouseListener,
IVWPropertyChangeSource,
IVWPropertyChangeListener,
ActionListener,
DropTargetListener {
    public static final Point DEFAULT_STEP_LOCATION = new Point(100, 100);
    public static final Point DEFAULT_TEXT_ANNOTATION_LOCATION = new Point(200, 100);
    private static final int SELECTOR_CURSOR_MODE = 0;
    private static final int ROUTE_SELECT_CURSOR_MODE = 1;
    private static final int ROUTE_DRAG_CURSOR_MODE = 2;
    private static final int STEP_SELECT_CURSOR_MODE = 3;
    private static final int ASSOCIATION_SELECT_CURSOR_MODE = 4;
    private static final int ASSOCIATION_DRAG_CURSOR_MODE = 5;
    private static final int TEXT_ANNOTATION_SELECT_CURSOR_MODE = 6;
    private Object m_srcOfDraggedItem = null;
    private VWStepRouteColors m_stepRouteColors = null;
    private int m_nCursorMode = 0;
    private VWDesignerDraggedRouteUI m_draggedRoute = null;
    private VWDesignerDraggedAssociationUI m_draggedAssociation = null;
    private boolean m_isEditable = false;
    private VWMapNodeUIToolkit m_vwMapNodeUIToolkit = null;
    private DropTarget m_dropTarget = null;
    private VWAuthPropertyData m_authPropertyData = null;
    private Point m_popupMenuLocation = null;
    private Vector m_changedItems = null;
    private Cursor m_selectorCursor = null;
    private Cursor m_stepSelectCursor = null;
    private Cursor m_routeDragCursor = null;
    private Cursor m_routeSelectCursor = null;
    private Cursor m_textAnnotationSelectCursor = null;
    private Cursor m_associationDragCursor = null;
    private Cursor m_associationSelectCursor = null;
    private VWPopupMenu m_stepMenu = null;
    private JMenuItem m_gotoMapMenuItem = null;
    private JMenu m_gotoMapMenu = null;
    private JSeparator m_stepSeparator1 = null;
    private JMenuItem m_cutStepMenuItem = null;
    private JMenuItem m_copyStepMenuItem = null;
    private JMenuItem m_deleteStepMenuItem = null;
    private JSeparator m_stepSeparator2 = null;
    private JMenuItem m_openPropertiesMenuItem = null;
    private JMenuItem m_addToStepPaletteMenuItem = null;
    private JSeparator m_stepSeparator3 = null;
    private JMenu m_changeStepTypeMenu = null;
    private ButtonGroup m_changeStepTypeGroup = null;
    private JRadioButtonMenuItem m_generalStepMenuItem = null;
    private JRadioButtonMenuItem m_callStepMenuItem = null;
    private JRadioButtonMenuItem m_systemStepMenuItem = null;
    private JRadioButtonMenuItem m_componentStepMenuItem = null;
    private VWPopupMenu m_routeMenu = null;
    private JMenuItem m_deleteRouteMenuItem = null;
    private JSeparator m_routeSeparator1 = null;
    private JMenuItem m_reverseRouteDirectionMenuItem = null;
    private VWPopupMenu m_textAnnotationMenu = null;
    private JMenuItem m_cutTextAnnotationMenuItem = null;
    private JMenuItem m_copyTextAnnotationMenuItem = null;
    private JMenuItem m_deleteTextAnnotationMenuItem = null;
    private JMenu m_changeTextAnnotationColorMenu = null;
    private ButtonGroup m_changeAnnotationColorMenuGroup = null;
    private JRadioButtonMenuItem m_blueColorMenuItem = null;
    private JRadioButtonMenuItem m_grayColorMenuItem = null;
    private JRadioButtonMenuItem m_greenColorMenuItem = null;
    private JRadioButtonMenuItem m_pinkColorMenuItem = null;
    private JRadioButtonMenuItem m_yellowColorMenuItem = null;
    private VWPopupMenu m_associationMenu = null;
    private JMenuItem m_deleteAssociationMenuItem = null;
    private VWPopupMenu m_mapMenu = null;
    private JMenuItem m_pasteMenuItem = null;
    private JSeparator m_mapSeparator1 = null;
    private JMenu m_newMenu = null;
    private JMenuItem m_newMapMenuItem = null;
    private JMenuItem m_newGeneralStepMenuItem = null;
    private JMenuItem m_newCallStepMenuItem = null;
    private JMenuItem m_newSystemStepMenuItem = null;
    private JMenuItem m_newComponentStepMenuItem = null;
    private JSeparator m_mapSeparator2 = null;
    private JMenuItem m_newTextAnnotationMenuItem = null;
    private JMenu m_mapsMenu = null;
    private JMenu m_callerMapsMenu = null;
    private JSeparator m_mapSeparator3 = null;
    private JMenuItem m_deleteCurrentMapMenuItem = null;

    public VWDesignerWorkflowMapPane(VWAuthPropertyData authPropertyData, VWDesignerWorkflowPane workflowPane) {
        super(workflowPane);
        try {
            this.m_authPropertyData = authPropertyData;
            this.setName("m_workflowPane_VWDesignerWorkflowMapPane");
            VWSessionInfo sessionInfo = workflowPane.getSessionInfo();
            this.m_vwMapNodeUIToolkit = new VWMapNodeUIToolkit(sessionInfo.getExternalClassLoader(), workflowPane.getMapAttributes());
            this.m_stepRouteColors = new VWStepRouteColors();
            this.m_stepMenu = new VWPopupMenu();
            this.m_gotoMapMenuItem = new JMenuItem(VWResource.s_gotoMapStr);
            this.m_gotoMapMenuItem.addActionListener(this);
            this.m_stepMenu.add(this.m_gotoMapMenuItem);
            this.m_gotoMapMenu = new JMenu(VWResource.s_gotoMapStr);
            this.m_stepMenu.add(this.m_gotoMapMenu);
            this.m_stepSeparator1 = new JSeparator();
            this.m_stepMenu.add(this.m_stepSeparator1);
            this.m_cutStepMenuItem = new JMenuItem(VWResource.s_cut);
            this.m_cutStepMenuItem.addActionListener(this);
            this.m_stepMenu.add(this.m_cutStepMenuItem);
            this.m_copyStepMenuItem = new JMenuItem(VWResource.s_copy);
            this.m_copyStepMenuItem.addActionListener(this);
            this.m_stepMenu.add(this.m_copyStepMenuItem);
            this.m_deleteStepMenuItem = new JMenuItem(VWResource.s_delete);
            this.m_deleteStepMenuItem.addActionListener(this);
            this.m_stepMenu.add(this.m_deleteStepMenuItem);
            this.m_stepSeparator2 = new JSeparator();
            this.m_stepMenu.add(this.m_stepSeparator2);
            this.m_openPropertiesMenuItem = new JMenuItem(VWResource.s_openProperties);
            this.m_openPropertiesMenuItem.addActionListener(this);
            this.m_stepMenu.add(this.m_openPropertiesMenuItem);
            if (this.m_authPropertyData.getDesignerCoreData().getApplicationMode() == 1) {
                this.m_addToStepPaletteMenuItem = new JMenuItem(VWResource.s_addToStepPaletteStr);
                this.m_addToStepPaletteMenuItem.addActionListener(this);
                this.m_stepMenu.add(this.m_addToStepPaletteMenuItem);
            }
            this.m_stepSeparator3 = new JSeparator();
            this.m_stepMenu.add(this.m_stepSeparator3);
            this.m_changeStepTypeMenu = new JMenu(VWResource.s_changeStepTypeStr);
            this.m_changeStepTypeGroup = new ButtonGroup();
            this.m_generalStepMenuItem = new JRadioButtonMenuItem(VWResource.s_generalStepStr);
            this.m_changeStepTypeGroup.add(this.m_generalStepMenuItem);
            this.m_changeStepTypeMenu.add(this.m_generalStepMenuItem);
            this.m_generalStepMenuItem.addActionListener(this);
            this.m_callStepMenuItem = new JRadioButtonMenuItem(VWResource.s_submapStepStr);
            this.m_changeStepTypeGroup.add(this.m_callStepMenuItem);
            this.m_changeStepTypeMenu.add(this.m_callStepMenuItem);
            this.m_callStepMenuItem.addActionListener(this);
            if (this.m_authPropertyData.getDesignerCoreData().getApplicationMode() == 1) {
                this.m_systemStepMenuItem = new JRadioButtonMenuItem(VWResource.s_systemStepStr);
                this.m_changeStepTypeGroup.add(this.m_systemStepMenuItem);
                this.m_changeStepTypeMenu.add(this.m_systemStepMenuItem);
                this.m_systemStepMenuItem.addActionListener(this);
                this.m_componentStepMenuItem = new JRadioButtonMenuItem(VWResource.s_componentStepStr);
                this.m_changeStepTypeGroup.add(this.m_componentStepMenuItem);
                this.m_changeStepTypeMenu.add(this.m_componentStepMenuItem);
                this.m_componentStepMenuItem.addActionListener(this);
            }
            this.m_stepMenu.add(this.m_changeStepTypeMenu);
            this.m_routeMenu = new VWPopupMenu();
            this.m_deleteRouteMenuItem = new JMenuItem(VWResource.s_delete);
            this.m_deleteRouteMenuItem.addActionListener(this);
            this.m_routeMenu.add(this.m_deleteRouteMenuItem);
            this.m_routeSeparator1 = new JSeparator();
            this.m_routeMenu.add(this.m_routeSeparator1);
            this.m_reverseRouteDirectionMenuItem = new JMenuItem(VWResource.s_reverseDirection);
            this.m_reverseRouteDirectionMenuItem.addActionListener(this);
            this.m_routeMenu.add(this.m_reverseRouteDirectionMenuItem);
            this.m_textAnnotationMenu = new VWPopupMenu();
            this.m_cutTextAnnotationMenuItem = new JMenuItem(VWResource.s_cut);
            this.m_cutTextAnnotationMenuItem.addActionListener(this);
            this.m_textAnnotationMenu.add(this.m_cutTextAnnotationMenuItem);
            this.m_copyTextAnnotationMenuItem = new JMenuItem(VWResource.s_copy);
            this.m_copyTextAnnotationMenuItem.addActionListener(this);
            this.m_textAnnotationMenu.add(this.m_copyTextAnnotationMenuItem);
            this.m_deleteTextAnnotationMenuItem = new JMenuItem(VWResource.s_delete);
            this.m_deleteTextAnnotationMenuItem.addActionListener(this);
            this.m_textAnnotationMenu.add(this.m_deleteTextAnnotationMenuItem);
            this.m_textAnnotationMenu.add(new JSeparator());
            this.m_changeTextAnnotationColorMenu = new JMenu(VWResource.s_changeTextAnnotationColor);
            this.m_textAnnotationMenu.add(this.m_changeTextAnnotationColorMenu);
            this.m_changeAnnotationColorMenuGroup = new ButtonGroup();
            this.m_blueColorMenuItem = new JRadioButtonMenuItem(VWResource.s_blue);
            this.m_blueColorMenuItem.addActionListener(this);
            this.m_changeAnnotationColorMenuGroup.add(this.m_blueColorMenuItem);
            this.m_changeTextAnnotationColorMenu.add(this.m_blueColorMenuItem);
            this.m_grayColorMenuItem = new JRadioButtonMenuItem(VWResource.s_gray);
            this.m_grayColorMenuItem.addActionListener(this);
            this.m_changeAnnotationColorMenuGroup.add(this.m_grayColorMenuItem);
            this.m_changeTextAnnotationColorMenu.add(this.m_grayColorMenuItem);
            this.m_greenColorMenuItem = new JRadioButtonMenuItem(VWResource.s_green);
            this.m_greenColorMenuItem.addActionListener(this);
            this.m_changeAnnotationColorMenuGroup.add(this.m_greenColorMenuItem);
            this.m_changeTextAnnotationColorMenu.add(this.m_greenColorMenuItem);
            this.m_pinkColorMenuItem = new JRadioButtonMenuItem(VWResource.s_pink);
            this.m_pinkColorMenuItem.addActionListener(this);
            this.m_changeAnnotationColorMenuGroup.add(this.m_pinkColorMenuItem);
            this.m_changeTextAnnotationColorMenu.add(this.m_pinkColorMenuItem);
            this.m_yellowColorMenuItem = new JRadioButtonMenuItem(VWResource.s_yellow);
            this.m_yellowColorMenuItem.addActionListener(this);
            this.m_changeAnnotationColorMenuGroup.add(this.m_yellowColorMenuItem);
            this.m_changeTextAnnotationColorMenu.add(this.m_yellowColorMenuItem);
            this.m_associationMenu = new VWPopupMenu();
            this.m_deleteAssociationMenuItem = new JMenuItem(VWResource.s_delete);
            this.m_deleteAssociationMenuItem.addActionListener(this);
            this.m_associationMenu.add(this.m_deleteAssociationMenuItem);
            this.m_mapMenu = new VWPopupMenu();
            this.m_pasteMenuItem = new JMenuItem(VWResource.s_paste);
            this.m_pasteMenuItem.addActionListener(this);
            this.m_pasteMenuItem.setEnabled(this.m_authPropertyData.getDesignerCoreData().getHasItemsInClipboard());
            this.m_mapMenu.add(this.m_pasteMenuItem);
            this.m_mapSeparator1 = new JSeparator();
            this.m_mapMenu.add(this.m_mapSeparator1);
            this.m_newMenu = new JMenu(VWResource.s_new);
            this.m_mapMenu.add(this.m_newMenu);
            this.m_newMapMenuItem = new JMenuItem(VWResource.s_mapDots);
            this.m_newMapMenuItem.addActionListener(this);
            this.m_newMenu.add(this.m_newMapMenuItem);
            this.m_newMenu.add(new JSeparator());
            this.m_newGeneralStepMenuItem = new JMenuItem(VWResource.s_newGeneralStepStr);
            this.m_newGeneralStepMenuItem.addActionListener(this);
            this.m_newMenu.add(this.m_newGeneralStepMenuItem);
            this.m_newCallStepMenuItem = new JMenuItem(VWResource.s_newSubmapStepStr);
            this.m_newCallStepMenuItem.addActionListener(this);
            this.m_newMenu.add(this.m_newCallStepMenuItem);
            if (this.m_authPropertyData.getDesignerCoreData().getApplicationMode() == 1) {
                this.m_newSystemStepMenuItem = new JMenuItem(VWResource.s_newSystemStepStr);
                this.m_newSystemStepMenuItem.addActionListener(this);
                this.m_newMenu.add(this.m_newSystemStepMenuItem);
                this.m_newComponentStepMenuItem = new JMenuItem(VWResource.s_newComponentStepStr);
                this.m_newComponentStepMenuItem.addActionListener(this);
                this.m_newMenu.add(this.m_newComponentStepMenuItem);
            }
            this.m_mapSeparator2 = new JSeparator();
            this.m_newMenu.add(this.m_mapSeparator2);
            this.m_newTextAnnotationMenuItem = new JMenuItem(VWResource.s_newTextAnnotationStr);
            this.m_newTextAnnotationMenuItem.addActionListener(this);
            this.m_newMenu.add(this.m_newTextAnnotationMenuItem);
            this.m_mapsMenu = new JMenu(VWResource.s_mapList);
            this.m_mapMenu.add(this.m_mapsMenu);
            this.m_callerMapsMenu = new JMenu(VWResource.s_callerMapsStr);
            this.m_mapMenu.add(this.m_callerMapsMenu);
            this.m_mapSeparator3 = new JSeparator();
            this.m_mapMenu.add(this.m_mapSeparator3);
            this.m_deleteCurrentMapMenuItem = new JMenuItem(VWResource.s_deleteCurrentSubmap);
            this.m_deleteCurrentMapMenuItem.addActionListener(this);
            this.m_mapMenu.add(this.m_deleteCurrentMapMenuItem);
            this.m_dropTarget = new DropTarget(this, 1, null);
            this.m_authPropertyData.getPropertyChangeEventNotifier().addPropertyChangeListener(this);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public boolean copySelectedItems(boolean bDeleteItems) {
        try {
            StringBuffer xmlStream = new StringBuffer();
            this.copySelectedStepsToXML(bDeleteItems, xmlStream);
            if (this.m_vwMapNodeUIToolkit.getMapAttribs().isTextAnnotationsVisible()) {
                this.copySelectedTextAnnotationsToXML(bDeleteItems, xmlStream);
            }
            if (xmlStream != null) {
                this.m_authPropertyData.getDesignerCoreData().setClipboardItems(xmlStream.toString());
            }
            this.m_pasteMenuItem.setEnabled(this.m_authPropertyData.getDesignerCoreData().getHasItemsInClipboard());
            return true;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), VWResource.s_error, 1);
            return false;
        }
    }

    public boolean deleteSelectedItems() {
        try {
            this.copySelectedStepsToXML(true, null);
            if (this.m_vwMapNodeUIToolkit.getMapAttribs().isTextAnnotationsVisible()) {
                this.copySelectedTextAnnotationsToXML(true, null);
            }
            return true;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), VWResource.s_error, 1);
            return false;
        }
    }

    public void pasteCopiedItems(Point pasteOrigin) {
        try {
            String xmlString = this.m_authPropertyData.getDesignerCoreData().getClipboardItems();
            if (xmlString != null && xmlString.length() > 0) {
                IVWPastable[] vwPastableItems = this.m_map.getMapDefinition().paste(xmlString);
                this.updateMapAfterPaste(vwPastableItems, pasteOrigin);
            }
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), VWResource.s_error, 1);
        }
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.m_draggedRoute != null) {
            this.m_draggedRoute.paintComponent(g);
        } else if (this.m_draggedAssociation != null) {
            this.m_draggedAssociation.paintComponent(g);
        }
    }

    public void createNewStep(int nStepType, Point location) {
        switch (nStepType) {
            case 7: {
                this.createNewGeneralStep(location);
                break;
            }
            case 9: {
                this.createNewCallStep(location);
                break;
            }
            case 11: {
                this.createNewSystemStep(location);
                break;
            }
            case 13: {
                this.createNewComponentStep(location);
            }
        }
    }

    public void createNewStep(VWMapNode newMapNode, Point location) {
        try {
            if (newMapNode == null || !this.m_isEditable) {
                return;
            }
            StringBuffer buffer = new StringBuffer();
            newMapNode.toXML(buffer);
            String xmlString = buffer.toString();
            if (xmlString != null && xmlString.length() > 0) {
                IVWPastable[] vwPastableItems = this.m_map.getMapDefinition().paste(xmlString);
                this.updateMapAfterPaste(vwPastableItems, location);
            }
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), VWResource.s_error, 1);
        }
    }

    public VWBaseTextAnnotationUI createNewTextAnnotation(Point location) {
        VWBaseTextAnnotationUI textAnnotationUI = null;
        try {
            VWTextAnnotationDefinition vwTextAnnotation;
            this.clearAllSelectedItems(false);
            if (this.m_map.getMapDefinition() != null && this.m_isEditable && (vwTextAnnotation = this.m_map.getMapDefinition().createTextAnnotation(null)) != null) {
                vwTextAnnotation.setLocation(location);
                textAnnotationUI = new VWBaseTextAnnotationUI(vwTextAnnotation, this.m_stepRouteColors, this.m_vwMapNodeUIToolkit.getMapAttribs());
                textAnnotationUI.setComponentOrientation(this.getComponentOrientation());
                Object[] textAnnotations = new Object[]{vwTextAnnotation};
                this.notifyOfItemsAdded(textAnnotations);
                this.m_textAnnotations.addElement(textAnnotationUI);
                this.focusGained(new FocusEvent(textAnnotationUI, 1004));
                textAnnotationUI.setFocus(false);
                this.mouseClicked(new MouseEvent(this, 500, 0L, 0, location.x, location.y, 1, false));
                textAnnotationUI.addFocusListener(this);
                this.recalculateBounds(0);
                this.repaint(textAnnotationUI.getBounds());
                this.setIsDirty(true);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), VWResource.s_error, 1);
        }
        return textAnnotationUI;
    }

    public void changeStepType(int newStepType) {
        try {
            Object[] selectedObjects = this.getSelectedObjects();
            if (selectedObjects != null && selectedObjects.length > 0) {
                int i;
                int[] selectedStepIDs = new int[selectedObjects.length];
                int nFocusStepID = -1;
                for (i = 0; i < selectedObjects.length; ++i) {
                    if (selectedObjects[i] instanceof VWMapNode) {
                        int nStepID;
                        VWMapNode mapNode = (VWMapNode)selectedObjects[i];
                        selectedStepIDs[i] = nStepID = mapNode.getStepId();
                        VWBaseStepUI stepUI = this.findStep(mapNode);
                        if (nFocusStepID == -1 && stepUI != null && stepUI.getFocus()) {
                            nFocusStepID = nStepID;
                        }
                        switch (newStepType) {
                            case 7: {
                                this.changeToGeneralStep(mapNode);
                                break;
                            }
                            case 9: {
                                this.changeToCallStep(mapNode);
                                break;
                            }
                            case 11: {
                                this.changeToSystemStep(mapNode);
                                break;
                            }
                            case 13: {
                                this.changeToComponentStep(mapNode);
                            }
                        }
                        continue;
                    }
                    selectedStepIDs[i] = -1;
                }
                this.clearAllSelectedItems(false);
                for (i = 0; i < selectedStepIDs.length; ++i) {
                    int nStepID = selectedStepIDs[i];
                    if (nStepID == -1) continue;
                    VWBaseStepUI stepUI = this.findStep(this.m_map.getMapDefinition().getStep(nStepID));
                    stepUI.setSelect(true);
                    if (nStepID != nFocusStepID) continue;
                    stepUI.setFocus(true);
                }
                this.notifySelectListeners(true);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), VWResource.s_error, 1);
        }
    }

    public void changeTextAnnotationColor(Color newColor) {
        try {
            Object[] selectedObjects = this.getSelectedObjects();
            if (selectedObjects != null && selectedObjects.length > 0) {
                for (int i = 0; i < selectedObjects.length; ++i) {
                    VWTextAnnotationDefinition textAnnoDef;
                    if (!(selectedObjects[i] instanceof VWTextAnnotationDefinition) || (textAnnoDef = (VWTextAnnotationDefinition)selectedObjects[i]) == null) continue;
                    textAnnoDef.setBgColor(newColor);
                    this.m_authPropertyData.setDirty();
                    this.m_changedItems = new Vector();
                    this.m_changedItems.addElement(textAnnoDef);
                    this.m_authPropertyData.getPropertyChangeEventNotifier().notifyPropertyChange(this, 572);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), VWResource.s_error, 1);
        }
    }

    public void removeReferences() {
        this.m_srcOfDraggedItem = null;
        this.m_stepRouteColors = null;
        this.m_draggedRoute = null;
        this.m_draggedAssociation = null;
        this.m_vwMapNodeUIToolkit = null;
        this.m_dropTarget.removeDropTargetListener(this);
        this.m_dropTarget = null;
        this.m_authPropertyData = null;
        this.m_popupMenuLocation = null;
        this.m_changedItems = null;
        this.m_selectorCursor = null;
        this.m_routeDragCursor = null;
        this.m_routeSelectCursor = null;
        this.m_stepSelectCursor = null;
        this.m_stepMenu.removeAll();
        this.m_stepMenu = null;
        this.m_gotoMapMenu.removeAll();
        this.m_gotoMapMenu = null;
        this.m_gotoMapMenuItem.removeActionListener(this);
        this.m_gotoMapMenuItem.removeAll();
        this.m_gotoMapMenuItem = null;
        this.m_stepSeparator1.removeAll();
        this.m_stepSeparator1 = null;
        this.m_cutStepMenuItem.removeActionListener(this);
        this.m_cutStepMenuItem.removeAll();
        this.m_cutStepMenuItem = null;
        this.m_copyStepMenuItem.removeActionListener(this);
        this.m_copyStepMenuItem.removeAll();
        this.m_copyStepMenuItem = null;
        this.m_deleteStepMenuItem.removeActionListener(this);
        this.m_deleteStepMenuItem.removeAll();
        this.m_deleteStepMenuItem = null;
        if (this.m_stepSeparator2 != null) {
            this.m_stepSeparator2.removeAll();
            this.m_stepSeparator2 = null;
        }
        if (this.m_openPropertiesMenuItem != null) {
            this.m_openPropertiesMenuItem.removeAll();
            this.m_openPropertiesMenuItem = null;
        }
        if (this.m_addToStepPaletteMenuItem != null) {
            this.m_addToStepPaletteMenuItem.removeAll();
            this.m_addToStepPaletteMenuItem = null;
        }
        if (this.m_stepSeparator3 != null) {
            this.m_stepSeparator3.removeAll();
            this.m_stepSeparator3 = null;
        }
        if (this.m_changeStepTypeMenu != null) {
            this.m_changeStepTypeMenu.removeAll();
            this.m_changeStepTypeMenu = null;
        }
        this.m_changeStepTypeGroup = null;
        if (this.m_generalStepMenuItem != null) {
            this.m_generalStepMenuItem.removeActionListener(this);
            this.m_generalStepMenuItem.removeAll();
            this.m_generalStepMenuItem = null;
        }
        if (this.m_callStepMenuItem != null) {
            this.m_callStepMenuItem.removeActionListener(this);
            this.m_callStepMenuItem.removeAll();
            this.m_callStepMenuItem = null;
        }
        if (this.m_systemStepMenuItem != null) {
            this.m_systemStepMenuItem.removeActionListener(this);
            this.m_systemStepMenuItem.removeAll();
            this.m_systemStepMenuItem = null;
        }
        if (this.m_componentStepMenuItem != null) {
            this.m_componentStepMenuItem.removeActionListener(this);
            this.m_componentStepMenuItem.removeAll();
            this.m_componentStepMenuItem = null;
        }
        this.m_routeMenu.removeAll();
        this.m_routeMenu = null;
        this.m_deleteRouteMenuItem.removeActionListener(this);
        this.m_deleteRouteMenuItem.removeAll();
        this.m_deleteRouteMenuItem = null;
        if (this.m_routeSeparator1 != null) {
            this.m_routeSeparator1.removeAll();
            this.m_routeSeparator1 = null;
        }
        if (this.m_reverseRouteDirectionMenuItem != null) {
            this.m_reverseRouteDirectionMenuItem.removeAll();
            this.m_reverseRouteDirectionMenuItem = null;
        }
        this.m_textAnnotationMenu.removeAll();
        this.m_textAnnotationMenu = null;
        this.m_cutTextAnnotationMenuItem.removeActionListener(this);
        this.m_cutTextAnnotationMenuItem.removeAll();
        this.m_cutTextAnnotationMenuItem = null;
        this.m_copyTextAnnotationMenuItem.removeActionListener(this);
        this.m_copyTextAnnotationMenuItem.removeAll();
        this.m_copyTextAnnotationMenuItem = null;
        this.m_deleteTextAnnotationMenuItem.removeActionListener(this);
        this.m_deleteTextAnnotationMenuItem.removeAll();
        this.m_deleteTextAnnotationMenuItem = null;
        this.m_changeAnnotationColorMenuGroup = null;
        this.m_blueColorMenuItem.removeActionListener(this);
        this.m_blueColorMenuItem.removeAll();
        this.m_blueColorMenuItem = null;
        this.m_grayColorMenuItem.removeActionListener(this);
        this.m_grayColorMenuItem.removeAll();
        this.m_grayColorMenuItem = null;
        this.m_greenColorMenuItem.removeActionListener(this);
        this.m_greenColorMenuItem.removeAll();
        this.m_greenColorMenuItem = null;
        this.m_pinkColorMenuItem.removeActionListener(this);
        this.m_pinkColorMenuItem.removeAll();
        this.m_pinkColorMenuItem = null;
        this.m_yellowColorMenuItem.removeActionListener(this);
        this.m_yellowColorMenuItem.removeAll();
        this.m_yellowColorMenuItem = null;
        this.m_associationMenu.removeAll();
        this.m_associationMenu = null;
        this.m_deleteAssociationMenuItem.removeAll();
        this.m_deleteAssociationMenuItem = null;
        this.m_mapMenu.removeAll();
        this.m_mapMenu = null;
        if (this.m_pasteMenuItem != null) {
            this.m_pasteMenuItem.removeActionListener(this);
            this.m_pasteMenuItem.removeAll();
            this.m_pasteMenuItem = null;
        }
        if (this.m_mapSeparator1 != null) {
            this.m_mapSeparator1.removeAll();
            this.m_mapSeparator1 = null;
        }
        this.m_newMenu.removeAll();
        this.m_newMenu = null;
        if (this.m_newMapMenuItem != null) {
            this.m_newMapMenuItem.removeActionListener(this);
            this.m_newMapMenuItem.removeAll();
            this.m_newMapMenuItem = null;
        }
        if (this.m_newGeneralStepMenuItem != null) {
            this.m_newGeneralStepMenuItem.removeActionListener(this);
            this.m_newGeneralStepMenuItem.removeAll();
            this.m_newGeneralStepMenuItem = null;
        }
        if (this.m_newCallStepMenuItem != null) {
            this.m_newCallStepMenuItem.removeActionListener(this);
            this.m_newCallStepMenuItem.removeAll();
            this.m_newCallStepMenuItem = null;
        }
        if (this.m_newSystemStepMenuItem != null) {
            this.m_newSystemStepMenuItem.removeActionListener(this);
            this.m_newSystemStepMenuItem.removeAll();
            this.m_newSystemStepMenuItem = null;
        }
        if (this.m_newComponentStepMenuItem != null) {
            this.m_newComponentStepMenuItem.removeActionListener(this);
            this.m_newComponentStepMenuItem.removeAll();
            this.m_newComponentStepMenuItem = null;
        }
        if (this.m_mapSeparator2 != null) {
            this.m_mapSeparator2.removeAll();
            this.m_mapSeparator2 = null;
        }
        if (this.m_newTextAnnotationMenuItem != null) {
            this.m_newTextAnnotationMenuItem.removeActionListener(this);
            this.m_newTextAnnotationMenuItem.removeAll();
            this.m_newTextAnnotationMenuItem = null;
        }
        this.m_mapsMenu.removeAll();
        this.m_mapsMenu = null;
        this.m_callerMapsMenu.removeAll();
        this.m_callerMapsMenu = null;
        this.m_mapSeparator3.removeAll();
        this.m_mapSeparator3 = null;
        if (this.m_deleteCurrentMapMenuItem != null) {
            this.m_deleteCurrentMapMenuItem.removeActionListener(this);
            this.m_deleteCurrentMapMenuItem.removeAll();
            this.m_deleteCurrentMapMenuItem = null;
        }
    }

    public void setMapDefinition(VWMap map) {
        if (map != null) {
            String mapName = map.getName();
            this.m_isEditable = this.m_workflowPane.getMapCache().isEditable(mapName);
            this.setBackground(this.m_colorManager.getColor(this.m_isEditable ? 1000 : 1001));
            try {
                if (this.m_isEditable) {
                    this.m_dropTarget.addDropTargetListener(this);
                } else {
                    this.m_dropTarget.removeDropTargetListener(this);
                }
            }
            catch (TooManyListenersException tmlex) {
                // empty catch block
            }
            this.m_map = map;
            this.m_steps = new Vector();
            this.m_routes = new Vector();
            this.m_textAnnotations = new Vector();
            this.m_associations = new Vector();
            this.setIsDirty(false);
            if (this.m_map.getMapDefinition() == null) {
                VWDebug.logWarning("The workflow map pane is set to display a null workflow map definition.");
            } else {
                try {
                    this.createStepUI();
                    this.createRouteUI();
                    this.createTextAnnotationUI();
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                    VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), VWResource.s_error, 1);
                }
            }
        }
        this.notifySelectListeners(true);
        this.recalculateBounds(0);
        this.repaint();
    }

    public String[] getParentMapNames() {
        return ((VWDesignerWorkflowPane)this.m_workflowPane).getCallerMaps(this.m_map.getName());
    }

    public void mouseClicked(MouseEvent event) {
        super.mouseClicked(event);
        if (this.getItemWithFocus() == null) {
            this.notifySelectListeners(false, false);
        }
    }

    public void mousePressed(MouseEvent event) {
        if (this.m_nCursorMode == 2) {
            VWBaseStepUI baseStepUI = (VWBaseStepUI)this.m_srcOfDraggedItem;
            this.m_draggedRoute = new VWDesignerDraggedRouteUI((VWBaseStepUI)this.m_srcOfDraggedItem);
            baseStepUI.setMode(3);
            this.invalidStepRegion(baseStepUI);
        } else if (this.m_nCursorMode == 5) {
            this.m_draggedAssociation = new VWDesignerDraggedAssociationUI((VWBaseTextAnnotationUI)this.m_srcOfDraggedItem);
        } else {
            super.mousePressed(event);
            if (!((VWDesignerWorkflowPane)this.m_workflowPane).getViewOnly() && event.isPopupTrigger()) {
                this.showPopup(event);
            }
        }
    }

    public void mouseReleased(MouseEvent event) {
        if (this.m_draggedRoute != null) {
            Point point = event.getPoint();
            this.m_draggedRoute.getSrcStep().setMode(0);
            this.invalidStepRegion(this.m_draggedRoute.getSrcStep());
            for (int nIndex = 0; nIndex < this.m_steps.size(); ++nIndex) {
                VWBaseStepUI destStep = (VWBaseStepUI)this.m_steps.elementAt(nIndex);
                try {
                    if (!destStep.contains(point) || destStep == this.m_draggedRoute.getSrcStep() || destStep.getMapNode() == this.m_map.getMapDefinition().getStartStep()) continue;
                    destStep.setMode(0);
                    this.invalidStepRegion(destStep);
                    this.createNewRoute(this.m_draggedRoute.getSrcStep(), destStep);
                    break;
                }
                catch (VWException ex) {
                    VWDebug.logException(ex);
                    VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), VWResource.s_error, 1);
                }
            }
            this.repaint(this.m_draggedRoute.getBounds());
            this.m_draggedRoute = null;
            this.setCursorMode(0);
        } else if (this.m_draggedAssociation != null) {
            int nIndex;
            Point point = event.getPoint();
            boolean bFoundTarget = false;
            for (nIndex = 0; nIndex < this.m_steps.size(); ++nIndex) {
                VWBaseStepUI destStep = (VWBaseStepUI)this.m_steps.elementAt(nIndex);
                try {
                    if (!destStep.contains(point)) continue;
                    destStep.setMode(0);
                    this.invalidStepRegion(destStep);
                    this.createNewAssociation(this.m_draggedAssociation.getSourceTextAnnotation(), destStep, true);
                    bFoundTarget = true;
                    break;
                }
                catch (VWException ex) {
                    VWDebug.logException(ex);
                    VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), VWResource.s_error, 1);
                }
            }
            if (!bFoundTarget) {
                for (nIndex = 0; nIndex < this.m_routes.size(); ++nIndex) {
                    VWBaseRouteUI destRoute = (VWBaseRouteUI)this.m_routes.elementAt(nIndex);
                    try {
                        if (!destRoute.contains(point)) continue;
                        this.createNewAssociation(this.m_draggedAssociation.getSourceTextAnnotation(), destRoute, true);
                        bFoundTarget = true;
                        break;
                    }
                    catch (VWException ex) {
                        VWDebug.logException(ex);
                        VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), VWResource.s_error, 1);
                    }
                }
            }
            this.repaint(this.m_draggedAssociation.getBounds());
            this.m_draggedAssociation = null;
            this.setCursorMode(0);
        } else {
            super.mouseReleased(event);
            if (!((VWDesignerWorkflowPane)this.m_workflowPane).getViewOnly() && event.isPopupTrigger()) {
                this.showPopup(event);
            }
        }
    }

    public void mouseDragged(MouseEvent event) {
        if (this.m_draggedRoute != null && this.m_isEditable) {
            Point point = event.getPoint();
            this.repaint(this.m_draggedRoute.getBounds());
            this.m_draggedRoute.mouseDragged(point);
            this.repaint(this.m_draggedRoute.getBounds());
            for (int nIndex = 0; nIndex < this.m_steps.size(); ++nIndex) {
                VWBaseStepUI destStep = (VWBaseStepUI)this.m_steps.elementAt(nIndex);
                try {
                    if (destStep == this.m_draggedRoute.getSrcStep()) continue;
                    if (destStep.contains(point) && destStep.getMapNode() != this.m_map.getMapDefinition().getStartStep()) {
                        destStep.setMode(3);
                        this.invalidStepRegion(destStep);
                        continue;
                    }
                    destStep.setMode(0);
                    this.invalidStepRegion(destStep);
                    continue;
                }
                catch (VWException ex) {
                    // empty catch block
                }
            }
        } else if (this.m_draggedAssociation != null && this.m_isEditable) {
            Point point = event.getPoint();
            this.repaint(this.m_draggedAssociation.getBounds());
            this.m_draggedAssociation.mouseDragged(point);
            this.repaint(this.m_draggedAssociation.getBounds());
            for (int nIndex = 0; nIndex < this.m_steps.size(); ++nIndex) {
                VWBaseStepUI destStep = (VWBaseStepUI)this.m_steps.elementAt(nIndex);
                try {
                    if (destStep.contains(point) && destStep.getMapNode() != this.m_map.getMapDefinition().getStartStep()) {
                        destStep.setMode(3);
                        this.invalidStepRegion(destStep);
                        continue;
                    }
                    destStep.setMode(0);
                    this.invalidStepRegion(destStep);
                    continue;
                }
                catch (VWException ex) {
                    // empty catch block
                }
            }
        } else {
            super.mouseDragged(event);
        }
    }

    public void mouseMoved(MouseEvent event) {
        int nIndex;
        boolean bChangeCursor = false;
        Point point = event.getPoint();
        int newCursorMode = 0;
        this.m_srcOfDraggedItem = null;
        for (nIndex = 0; nIndex < this.m_steps.size(); ++nIndex) {
            VWBaseStepUI stepUI = (VWBaseStepUI)this.m_steps.elementAt(nIndex);
            VWRouteBubbleRenderer routeBubbleRenderer = stepUI.getRouteBubbleRenderer();
            int nQuadrant = routeBubbleRenderer.getQuadrantFromPoint(point);
            if (nQuadrant != -1) {
                if (this.m_isEditable && !((VWDesignerWorkflowPane)this.m_workflowPane).getViewOnly() && nQuadrant != 0) {
                    newCursorMode = 2;
                    this.m_srcOfDraggedItem = stepUI;
                    bChangeCursor = true;
                } else if (stepUI.contains(point)) {
                    newCursorMode = 3;
                    bChangeCursor = true;
                }
            }
            this.invalidStepRegion(stepUI);
        }
        if (!bChangeCursor) {
            for (nIndex = 0; nIndex < this.m_routes.size(); ++nIndex) {
                VWBaseRouteUI route = (VWBaseRouteUI)this.m_routes.elementAt(nIndex);
                if (!route.contains(point)) continue;
                newCursorMode = 1;
                bChangeCursor = true;
            }
        }
        boolean bShowTextAnnotations = this.m_vwMapNodeUIToolkit.getMapAttribs().isTextAnnotationsVisible();
        if (!bChangeCursor && bShowTextAnnotations) {
            for (int nIndex2 = 0; nIndex2 < this.m_textAnnotations.size(); ++nIndex2) {
                VWBaseTextAnnotationUI textAnnotation = (VWBaseTextAnnotationUI)this.m_textAnnotations.elementAt(nIndex2);
                if (this.m_isEditable && !((VWDesignerWorkflowPane)this.m_workflowPane).getViewOnly() && textAnnotation.isPointNearEdge(point)) {
                    newCursorMode = 5;
                    this.m_srcOfDraggedItem = textAnnotation;
                    bChangeCursor = true;
                    continue;
                }
                if (!textAnnotation.contains(point)) continue;
                newCursorMode = 6;
                bChangeCursor = true;
            }
        }
        if (!bChangeCursor && bShowTextAnnotations) {
            for (int nIndex3 = 0; nIndex3 < this.m_associations.size(); ++nIndex3) {
                VWBaseAssociationUI association = (VWBaseAssociationUI)this.m_associations.elementAt(nIndex3);
                if (!association.contains(point)) continue;
                newCursorMode = 4;
                bChangeCursor = true;
            }
        }
        if (newCursorMode != this.m_nCursorMode) {
            this.setCursorMode(newCursorMode);
        }
    }

    public void notifyPropertyChange() {
    }

    public Vector getItemsChanged() {
        return this.m_changedItems;
    }

    public void propertyChange(VWPropertyChangeEvent event) {
        block18: {
            try {
                Object object = event.getSource();
                if (!(object instanceof IVWPropertyChangeSource)) break block18;
                IVWPropertyChangeSource source = (IVWPropertyChangeSource)object;
                switch (event.getID()) {
                    case 501: 
                    case 503: {
                        Vector items = source.getItemsChanged();
                        for (int i = 0; i < items.size(); ++i) {
                            VWBaseRouteUI routeUI;
                            object = items.elementAt(i);
                            if (object instanceof VWMapNode) {
                                VWBaseStepUI stepUI = this.findStep((VWMapNode)object);
                                if (stepUI == null) continue;
                                stepUI.reloadStepImages();
                                this.invalidStepRegion(stepUI);
                                continue;
                            }
                            if (!(object instanceof VWRouteDefinition) || (routeUI = this.findRoute((VWRouteDefinition)object)) == null) continue;
                            this.repaint(routeUI.getBounds());
                        }
                        break;
                    }
                    case 502: {
                        Vector items = source.getItemsChanged();
                        for (int i = 0; i < items.size(); ++i) {
                            VWMapNode mapNode;
                            VWRouteDefinition[] routeDefs;
                            object = items.elementAt(i);
                            if (!(object instanceof VWMapNode) || (routeDefs = (mapNode = (VWMapNode)object).getNextRoutes()) == null) continue;
                            for (int j = 0; j < routeDefs.length; ++j) {
                                VWBaseRouteUI routeUI = this.findRoute(routeDefs[j]);
                                if (routeUI == null) continue;
                                this.repaint(routeUI.getBounds());
                            }
                        }
                        break;
                    }
                    case 524: {
                        Vector items = source.getItemsChanged();
                        for (int i = 0; i < items.size(); ++i) {
                            VWRouteDefinition[] routeDefs;
                            object = items.elementAt(i);
                            if (!(object instanceof VWStepDefinition)) continue;
                            VWStepDefinition stepDef = (VWStepDefinition)object;
                            VWBaseStepUI stepUI = this.findStep(stepDef);
                            if (stepUI != null) {
                                this.invalidStepRegion(stepUI);
                            }
                            if ((routeDefs = stepDef.getPreviousRoutes()) == null) continue;
                            for (int j = 0; j < routeDefs.length; ++j) {
                                VWBaseRouteUI routeUI = this.findRoute(routeDefs[j]);
                                if (routeUI == null) continue;
                                this.repaint(routeUI.getBounds());
                            }
                        }
                        break;
                    }
                    case 577: {
                        Vector items = source.getItemsChanged();
                        for (int nIndex = 0; nIndex < items.size(); ++nIndex) {
                            VWBaseAssociationUI associationUI;
                            object = items.elementAt(nIndex);
                            if (!(object instanceof VWAssociationDefinition) || (associationUI = this.findAssociation((VWAssociationDefinition)object)) == null) continue;
                            this.repaint(associationUI.getBounds());
                        }
                        break;
                    }
                    case 572: {
                        Vector items = source.getItemsChanged();
                        for (int nIndex = 0; nIndex < items.size(); ++nIndex) {
                            VWBaseTextAnnotationUI TextAnnotationUI;
                            object = items.elementAt(nIndex);
                            if (!(object instanceof VWTextAnnotationDefinition) || (TextAnnotationUI = this.findTextAnnotation((VWTextAnnotationDefinition)object)) == null) continue;
                            this.invalidateTextAnnotationRegion(TextAnnotationUI);
                        }
                        break;
                    }
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), VWResource.s_error, 1);
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.m_cutStepMenuItem || source == this.m_cutTextAnnotationMenuItem) {
            this.copySelectedItems(true);
        } else if (source == this.m_copyStepMenuItem || source == this.m_copyTextAnnotationMenuItem) {
            this.copySelectedItems(false);
        } else if (source == this.m_deleteRouteMenuItem || source == this.m_deleteStepMenuItem || source == this.m_deleteAssociationMenuItem || source == this.m_deleteTextAnnotationMenuItem) {
            this.deleteSelectedItems();
        } else if (source == this.m_reverseRouteDirectionMenuItem) {
            this.performReverseRouteDirectionAction();
        } else if (source == this.m_deleteCurrentMapMenuItem) {
            this.m_workflowPane.getToolbarActionNotifier().notifyToolbarAction(this, 501);
        } else if (source == this.m_generalStepMenuItem) {
            this.changeStepType(7);
        } else if (source == this.m_callStepMenuItem) {
            this.changeStepType(9);
        } else if (source == this.m_systemStepMenuItem) {
            this.changeStepType(11);
        } else if (source == this.m_componentStepMenuItem) {
            this.changeStepType(13);
        } else if (source == this.m_gotoMapMenuItem) {
            this.performGotoMapAction();
        } else if (source.equals(this.m_openPropertiesMenuItem)) {
            this.performOpenPropertiesAction();
        } else if (source.equals(this.m_addToStepPaletteMenuItem)) {
            this.performAddToStepPaletteAction();
        } else if (source == this.m_pasteMenuItem) {
            this.pasteCopiedItems(this.m_popupMenuLocation);
        } else if (source == this.m_newMapMenuItem) {
            this.m_workflowPane.getToolbarActionNotifier().notifyToolbarAction(this, 500);
        } else if (source == this.m_newGeneralStepMenuItem) {
            this.createNewStep(7, this.m_popupMenuLocation);
        } else if (source == this.m_newCallStepMenuItem) {
            this.createNewStep(9, this.m_popupMenuLocation);
        } else if (source == this.m_newSystemStepMenuItem) {
            this.createNewStep(11, this.m_popupMenuLocation);
        } else if (source == this.m_newComponentStepMenuItem) {
            this.createNewStep(13, this.m_popupMenuLocation);
        } else if (source == this.m_newTextAnnotationMenuItem) {
            this.createNewTextAnnotation(this.m_popupMenuLocation);
        } else if (source == this.m_blueColorMenuItem) {
            this.changeTextAnnotationColor(VWColorListCellRenderer.COLOR_BLUE);
        } else if (source == this.m_grayColorMenuItem) {
            this.changeTextAnnotationColor(VWColorListCellRenderer.COLOR_GRAY);
        } else if (source == this.m_greenColorMenuItem) {
            this.changeTextAnnotationColor(VWColorListCellRenderer.COLOR_GREEN);
        } else if (source == this.m_pinkColorMenuItem) {
            this.changeTextAnnotationColor(VWColorListCellRenderer.COLOR_PINK);
        } else if (source == this.m_yellowColorMenuItem) {
            this.changeTextAnnotationColor(VWColorListCellRenderer.COLOR_YELLOW);
        } else if (source instanceof JMenuItem) {
            JMenuItem menuItem = (JMenuItem)source;
            String mapName = menuItem.getText();
            if (VWStringUtils.compare(mapName, VWResource.s_mainMapLabel.toString("Workflow")) == 0) {
                mapName = "Workflow";
            } else {
                VWMapCache mapCache = this.m_workflowPane.getMapCache();
                if (mapCache != null) {
                    String[] mapNames = mapCache.getMapNames();
                    for (int i = 0; i < mapNames.length; ++i) {
                        if (VWStringUtils.compare(mapName, VWResource.s_readOnlyLabel.toString(mapNames[i])) != 0) continue;
                        mapName = mapNames[i];
                        break;
                    }
                }
            }
            if (mapName != null) {
                this.m_workflowPane.getToolbarActionNotifier().notifyToolbarAction(this, 503, mapName);
            }
        }
    }

    public void dragEnter(DropTargetDragEvent dtde) {
        if (this.m_isEditable) {
            dtde.acceptDrag(1);
        } else {
            dtde.rejectDrag();
        }
    }

    public void dragOver(DropTargetDragEvent dtde) {
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public void dragExit(DropTargetEvent dte) {
    }

    public void drop(DropTargetDropEvent dtde) {
        block11: {
            try {
                Transferable tr = dtde.getTransferable();
                if (tr != null && tr.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    String xmlString = null;
                    try {
                        dtde.acceptDrop(1);
                        xmlString = (String)tr.getTransferData(DataFlavor.stringFlavor);
                    }
                    catch (IllegalStateException ex) {
                        VWDebug.logException(ex);
                        VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), VWResource.s_error, 1);
                    }
                    try {
                        if (xmlString != null && xmlString.length() > 0) {
                            if (xmlString.startsWith("Text Annotation")) {
                                this.createNewTextAnnotation(dtde.getLocation());
                            } else {
                                IVWPastable[] vwPastableItems = this.m_map.getMapDefinition().paste(xmlString);
                                this.updateMapAfterPaste(vwPastableItems, dtde.getLocation());
                            }
                        }
                    }
                    catch (VWException ex) {
                        VWDebug.logException(ex);
                        VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), VWResource.s_error, 1);
                    }
                    dtde.getDropTargetContext().dropComplete(true);
                    break block11;
                }
                VWDebug.logInfo("Drag rejected - Unsupported data flavor");
                dtde.rejectDrop();
            }
            catch (IOException ex) {
                VWDebug.logException(ex);
                VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), VWResource.s_error, 1);
            }
            catch (UnsupportedFlavorException ex) {
                VWDebug.logException(ex);
                VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), VWResource.s_error, 1);
            }
        }
    }

    protected void performAddToStepPaletteAction() {
        for (int nIndex = 0; nIndex < this.m_steps.size(); ++nIndex) {
            VWBaseStepUI step = (VWBaseStepUI)this.m_steps.elementAt(nIndex);
            if (!step.getSelect() || step.getStepType() == 0) continue;
            ((VWDesignerWorkflowPane)this.m_workflowPane).addStepToPalette(step.getMapNode());
        }
    }

    private void createStepUI() throws Exception {
        VWMapNode[] vwMapNodes = this.m_map.getMapDefinition().getSteps();
        if (vwMapNodes != null) {
            for (int nIndex = 0; nIndex < vwMapNodes.length; ++nIndex) {
                Component stepUI = null;
                switch (VWStepUtils.getStepType(vwMapNodes[nIndex])) {
                    case 0: {
                        stepUI = new VWLaunchStepUI((VWStepDefinition)vwMapNodes[nIndex], this.m_vwMapNodeUIToolkit);
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 6: {
                        stepUI = new VWGeneralStepUI((VWStepDefinition)vwMapNodes[nIndex], true, this.m_vwMapNodeUIToolkit);
                        break;
                    }
                    case 10: {
                        stepUI = new VWSubmapStepUI((VWCompoundStepDefinition)vwMapNodes[nIndex], true, this.m_vwMapNodeUIToolkit);
                        break;
                    }
                    case 12: {
                        stepUI = new VWSystemStepUI((VWCompoundStepDefinition)vwMapNodes[nIndex], true, this.m_vwMapNodeUIToolkit);
                        break;
                    }
                    case 14: {
                        stepUI = new VWComponentStepUI((VWCompoundStepDefinition)vwMapNodes[nIndex], true, this.m_vwMapNodeUIToolkit);
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 5: {
                        stepUI = new VWGeneralStepUI((VWStepDefinition)vwMapNodes[nIndex], this.m_vwMapNodeUIToolkit);
                        break;
                    }
                    case 9: {
                        stepUI = new VWSubmapStepUI((VWCompoundStepDefinition)vwMapNodes[nIndex], this.m_vwMapNodeUIToolkit);
                        break;
                    }
                    case 11: {
                        stepUI = new VWSystemStepUI((VWCompoundStepDefinition)vwMapNodes[nIndex], this.m_vwMapNodeUIToolkit);
                        break;
                    }
                    case 13: {
                        stepUI = new VWComponentStepUI((VWCompoundStepDefinition)vwMapNodes[nIndex], this.m_vwMapNodeUIToolkit);
                    }
                }
                if (stepUI == null) continue;
                stepUI.setComponentOrientation(this.getComponentOrientation());
                this.m_steps.addElement(stepUI);
                VWRouteBubbleRenderer bubbleRenderer = ((VWBaseStepUI)stepUI).getRouteBubbleRenderer();
                if (bubbleRenderer != null) {
                    bubbleRenderer.setMapIsEditable(this.m_isEditable);
                }
                ((VWBaseStepUI)stepUI).addFocusListener(this);
            }
        } else {
            VWDebug.logError("The map does not have any steps.  It should minimally have a launch step or start step.");
        }
    }

    private void createRouteUI() throws Exception {
        VWMapNode[] vwMapNodes = this.m_map.getMapDefinition().getSteps();
        if (vwMapNodes != null) {
            for (int nIndex = 0; nIndex < vwMapNodes.length; ++nIndex) {
                VWRouteDefinition[] vwRoutes = vwMapNodes[nIndex].getNextRoutes();
                if (vwRoutes == null) continue;
                VWBaseStepUI prevStep = this.findStep(vwMapNodes[nIndex]);
                for (int nRouteIndex = 0; nRouteIndex < vwRoutes.length; ++nRouteIndex) {
                    VWBaseRouteUI routeUI = null;
                    VWBaseStepUI nextStep = this.findStep(vwRoutes[nRouteIndex].getDestinationStep());
                    routeUI = nextStep.hasARouteToStep(prevStep) ? new VWBaseRouteUI(vwRoutes[nRouteIndex], prevStep, nextStep, false, 2, this.m_stepRouteColors, this.m_workflowPane.getMapAttributes()) : new VWBaseRouteUI(vwRoutes[nRouteIndex], prevStep, nextStep, false, 1, this.m_stepRouteColors, this.m_workflowPane.getMapAttributes());
                    routeUI.addFocusListener(this);
                    prevStep.addNextRoute(routeUI, nextStep);
                    nextStep.addPrevRoute(routeUI, prevStep);
                    this.repaint(routeUI.getBounds());
                    this.m_routes.addElement(routeUI);
                }
            }
        }
    }

    private void createTextAnnotationUI() throws Exception {
        VWTextAnnotationDefinition[] vwTextAnnotations = this.m_map.getMapDefinition().getTextAnnotations();
        if (vwTextAnnotations != null) {
            for (int nIndex = 0; nIndex < vwTextAnnotations.length; ++nIndex) {
                VWBaseTextAnnotationUI textAnnotationUI = new VWBaseTextAnnotationUI(vwTextAnnotations[nIndex], this.m_stepRouteColors, this.m_workflowPane.getMapAttributes());
                textAnnotationUI.setComponentOrientation(this.getComponentOrientation());
                textAnnotationUI.addFocusListener(this);
                this.m_textAnnotations.addElement(textAnnotationUI);
                VWAssociationDefinition[] vwAssociations = vwTextAnnotations[nIndex].getAllAssociations();
                if (vwAssociations == null) continue;
                for (int nAssociationIndex = 0; nAssociationIndex < vwAssociations.length; ++nAssociationIndex) {
                    VWBaseAssociationUI associationUI = null;
                    switch (vwAssociations[nAssociationIndex].getTargetType()) {
                        case 1: {
                            VWBaseStepUI stepUI = this.findStep(this.m_map.getMapDefinition().getStep(vwAssociations[nAssociationIndex].getTargetId()));
                            if (stepUI == null) break;
                            associationUI = new VWBaseAssociationUI(vwAssociations[nAssociationIndex], textAnnotationUI, stepUI, this.m_stepRouteColors, this.m_workflowPane.getMapAttributes());
                            textAnnotationUI.addAssociation(associationUI, stepUI);
                            stepUI.addAssociation(associationUI, textAnnotationUI);
                            break;
                        }
                        case 2: {
                            VWBaseRouteUI routeUI = this.findRoute(vwAssociations[nAssociationIndex].getTargetId());
                            if (routeUI == null) break;
                            associationUI = new VWBaseAssociationUI(vwAssociations[nAssociationIndex], textAnnotationUI, routeUI, this.m_stepRouteColors, this.m_workflowPane.getMapAttributes());
                            textAnnotationUI.addAssociation(associationUI, routeUI);
                            routeUI.addAssociation(associationUI, textAnnotationUI);
                            break;
                        }
                    }
                    if (associationUI == null) continue;
                    associationUI.addFocusListener(this);
                    this.repaint(associationUI.getBounds());
                    this.m_associations.addElement(associationUI);
                }
            }
        }
    }

    private void setCursorMode(int newCursorMode) {
        Cursor cursor = this.getCursor();
        switch (newCursorMode) {
            case 3: {
                cursor = this.getStepSelectCursor();
                this.m_nCursorMode = 3;
                break;
            }
            case 2: {
                cursor = this.getRouteDragCursor();
                this.m_nCursorMode = 2;
                break;
            }
            case 1: {
                cursor = this.getRouteSelectCursor();
                this.m_nCursorMode = 1;
                break;
            }
            case 6: {
                cursor = this.getTextAnnotationSelectCursor();
                this.m_nCursorMode = 6;
                break;
            }
            case 5: {
                cursor = this.getAssociationDragCursor();
                this.m_nCursorMode = 5;
                break;
            }
            case 4: {
                cursor = this.getAssociationSelectCursor();
                this.m_nCursorMode = 4;
                break;
            }
            default: {
                cursor = this.getSelectorCursor();
                this.m_nCursorMode = 0;
            }
        }
        this.setCursor(cursor);
    }

    private void showPopup(MouseEvent event) {
        this.m_popupMenuLocation = event.getPoint();
        IVWSelectWorkflowItem item = this.getItemAtLocation(this.m_popupMenuLocation);
        if (item != null) {
            if (item instanceof VWBaseStepUI) {
                this.showStepContextMenu(event, (VWBaseStepUI)item);
            } else if (item instanceof VWBaseRouteUI) {
                if (this.m_routeMenu != null && this.m_isEditable) {
                    boolean bEnable;
                    block23: {
                        bEnable = false;
                        try {
                            VWMapNode destinationStep;
                            VWRouteDefinition[] outgoingRoutes;
                            VWRouteDefinition routeDef = ((VWBaseRouteUI)item).getRouteDefinition();
                            VWMapNode sourceStep = routeDef.getSourceStep();
                            int nStepType = VWStepUtils.getStepType(sourceStep);
                            boolean bl = bEnable = nStepType != 0 && !VWStepUtils.isStartStep(nStepType);
                            if (!bEnable || (outgoingRoutes = (destinationStep = routeDef.getDestinationStep()).getNextRoutes()) == null) break block23;
                            for (int nIndex = 0; nIndex < outgoingRoutes.length; ++nIndex) {
                                if (outgoingRoutes[nIndex].getDestinationStep() != sourceStep) continue;
                                bEnable = false;
                                break;
                            }
                        }
                        catch (VWException ex) {
                            VWDebug.logException(ex);
                        }
                    }
                    this.m_routeSeparator1.setVisible(bEnable);
                    this.m_reverseRouteDirectionMenuItem.setVisible(bEnable);
                    this.m_routeMenu.show(event.getComponent(), event.getX(), event.getY());
                }
            } else if (item instanceof VWBaseTextAnnotationUI) {
                if (!this.m_vwMapNodeUIToolkit.getMapAttribs().isTextAnnotationsVisible()) {
                    this.showMapContextMenu(event);
                }
                if (this.m_textAnnotationMenu != null) {
                    Color bgColor;
                    VWTextAnnotationDefinition textAnnoDef = ((VWBaseTextAnnotationUI)item).getDefinition();
                    if (textAnnoDef != null && (bgColor = textAnnoDef.getBgColor()) != null) {
                        if (bgColor.equals(VWColorListCellRenderer.COLOR_BLUE)) {
                            this.m_blueColorMenuItem.setSelected(true);
                        }
                        if (bgColor.equals(VWColorListCellRenderer.COLOR_GRAY)) {
                            this.m_grayColorMenuItem.setSelected(true);
                        }
                        if (bgColor.equals(VWColorListCellRenderer.COLOR_GREEN)) {
                            this.m_greenColorMenuItem.setSelected(true);
                        }
                        if (bgColor.equals(VWColorListCellRenderer.COLOR_PINK)) {
                            this.m_pinkColorMenuItem.setSelected(true);
                        }
                        if (bgColor.equals(VWColorListCellRenderer.COLOR_YELLOW)) {
                            this.m_yellowColorMenuItem.setSelected(true);
                        }
                    }
                    this.m_textAnnotationMenu.setVisible(this.m_isEditable);
                    this.m_textAnnotationMenu.show(event.getComponent(), event.getX(), event.getY());
                }
            } else if (item instanceof VWBaseAssociationUI) {
                if (!this.m_vwMapNodeUIToolkit.getMapAttribs().isTextAnnotationsVisible()) {
                    this.showMapContextMenu(event);
                }
                if (this.m_associationMenu != null) {
                    this.m_associationMenu.setVisible(this.m_isEditable);
                    this.m_associationMenu.show(event.getComponent(), event.getX(), event.getY());
                }
            }
        } else {
            this.showMapContextMenu(event);
        }
    }

    private void showStepContextMenu(MouseEvent event, VWBaseStepUI stepUI) {
        int nStepType;
        if (this.m_stepMenu != null && (nStepType = stepUI.getStepType()) != 0) {
            switch (nStepType) {
                case 2: 
                case 4: 
                case 6: {
                    this.setupGeneralStepContextMenu(true);
                    break;
                }
                case 10: {
                    this.setupCallStepContextMenu(true, stepUI.getMapNode());
                    break;
                }
                case 12: {
                    this.setupSystemStepContextMenu(true, stepUI.getMapNode());
                    break;
                }
                case 14: {
                    this.setupComponentStepContextMenu(true, stepUI.getMapNode());
                    break;
                }
                case 1: 
                case 3: 
                case 5: {
                    this.setupGeneralStepContextMenu(false);
                    break;
                }
                case 9: {
                    this.setupCallStepContextMenu(false, stepUI.getMapNode());
                    break;
                }
                case 11: {
                    this.setupSystemStepContextMenu(false, stepUI.getMapNode());
                    break;
                }
                case 13: {
                    this.setupComponentStepContextMenu(false, stepUI.getMapNode());
                }
            }
            if (this.m_stepSeparator3 != null) {
                this.m_stepSeparator3.setVisible(this.m_isEditable);
            }
            if (this.m_changeStepTypeMenu != null) {
                this.m_changeStepTypeMenu.setVisible(this.m_isEditable);
            }
            this.m_stepMenu.show(event.getComponent(), event.getX(), event.getY());
        }
    }

    private void setupGeneralStepContextMenu(boolean startStep) {
        this.m_gotoMapMenuItem.setVisible(false);
        this.m_gotoMapMenu.setVisible(false);
        this.m_stepSeparator1.setVisible(false);
        this.m_cutStepMenuItem.setVisible(!startStep && this.m_isEditable);
        this.m_deleteStepMenuItem.setVisible(!startStep && this.m_isEditable);
        boolean bEnableOpenProperties = false;
        Object[] selectedObjects = this.getSelectedObjects();
        if (selectedObjects.length > 1) {
            bEnableOpenProperties = true;
        }
        this.m_stepSeparator2.setVisible(bEnableOpenProperties && this.m_addToStepPaletteMenuItem != null);
        this.m_openPropertiesMenuItem.setVisible(bEnableOpenProperties);
        if (this.m_generalStepMenuItem != null) {
            this.m_generalStepMenuItem.removeActionListener(this);
            this.m_generalStepMenuItem.setSelected(true);
            this.m_generalStepMenuItem.addActionListener(this);
        }
    }

    private void setupCallStepContextMenu(boolean startStep, VWMapNode mapNode) {
        boolean bEnableGotoMap = false;
        Object[] selectedObjects = this.getSelectedObjects();
        if (selectedObjects.length == 1 && VWStepUtils.getCalledMapName(mapNode) != null) {
            bEnableGotoMap = true;
        }
        this.m_gotoMapMenuItem.setVisible(bEnableGotoMap);
        this.m_gotoMapMenu.setVisible(false);
        this.m_stepSeparator1.setVisible(bEnableGotoMap);
        this.m_cutStepMenuItem.setVisible(!startStep && this.m_isEditable);
        this.m_deleteStepMenuItem.setVisible(!startStep && this.m_isEditable);
        boolean bEnableOpenProperties = false;
        if (selectedObjects.length > 1) {
            bEnableOpenProperties = true;
        }
        this.m_stepSeparator2.setVisible(bEnableOpenProperties && this.m_addToStepPaletteMenuItem != null);
        this.m_openPropertiesMenuItem.setVisible(bEnableOpenProperties);
        if (this.m_callStepMenuItem != null) {
            this.m_callStepMenuItem.removeActionListener(this);
            this.m_callStepMenuItem.setSelected(true);
            this.m_callStepMenuItem.addActionListener(this);
        }
    }

    private void setupSystemStepContextMenu(boolean startStep, VWMapNode mapNode) {
        Object[] selectedObjects = this.getSelectedObjects();
        String[] callMapNames = VWStepUtils.getCalledMapNames(mapNode);
        if (selectedObjects.length == 1 && callMapNames != null) {
            int size = callMapNames.length;
            if (size == 1) {
                this.m_gotoMapMenuItem.setVisible(true);
                this.m_gotoMapMenu.setVisible(false);
            } else {
                this.m_gotoMapMenuItem.setVisible(false);
                this.m_gotoMapMenu.setVisible(true);
                this.m_gotoMapMenu.removeAll();
                for (int i = 0; i < size; ++i) {
                    JMenuItem menuItem = new JMenuItem(callMapNames[i]);
                    menuItem.addActionListener(this);
                    this.m_gotoMapMenu.add(menuItem);
                }
            }
            this.m_stepSeparator1.setVisible(true);
        } else {
            this.m_gotoMapMenuItem.setVisible(false);
            this.m_gotoMapMenu.setVisible(false);
            this.m_stepSeparator1.setVisible(false);
        }
        this.m_cutStepMenuItem.setVisible(!startStep && this.m_isEditable);
        this.m_deleteStepMenuItem.setVisible(!startStep && this.m_isEditable);
        boolean bEnableOpenProperties = false;
        if (selectedObjects.length > 1) {
            bEnableOpenProperties = true;
        }
        this.m_stepSeparator2.setVisible(bEnableOpenProperties && this.m_addToStepPaletteMenuItem != null);
        this.m_openPropertiesMenuItem.setVisible(bEnableOpenProperties);
        if (this.m_systemStepMenuItem != null) {
            this.m_systemStepMenuItem.removeActionListener(this);
            this.m_systemStepMenuItem.setSelected(true);
            this.m_systemStepMenuItem.addActionListener(this);
        }
    }

    private void setupComponentStepContextMenu(boolean startStep, VWMapNode mapNode) {
        this.m_gotoMapMenuItem.setVisible(false);
        this.m_gotoMapMenu.setVisible(false);
        this.m_stepSeparator1.setVisible(false);
        this.m_cutStepMenuItem.setVisible(!startStep && this.m_isEditable);
        this.m_deleteStepMenuItem.setVisible(!startStep && this.m_isEditable);
        boolean bEnableOpenProperties = false;
        Object[] selectedObjects = this.getSelectedObjects();
        if (selectedObjects.length > 1) {
            bEnableOpenProperties = true;
        }
        this.m_stepSeparator2.setVisible(bEnableOpenProperties && this.m_addToStepPaletteMenuItem != null);
        this.m_openPropertiesMenuItem.setVisible(bEnableOpenProperties);
        if (this.m_componentStepMenuItem != null) {
            this.m_componentStepMenuItem.removeActionListener(this);
            this.m_componentStepMenuItem.setSelected(true);
            this.m_componentStepMenuItem.addActionListener(this);
        }
    }

    private void showMapContextMenu(MouseEvent event) {
        try {
            if (this.m_mapMenu != null) {
                String[] mapNames;
                if (this.m_pasteMenuItem != null) {
                    this.m_pasteMenuItem.setEnabled(this.m_authPropertyData != null && this.m_authPropertyData.getDesignerCoreData().getHasItemsInClipboard());
                    this.m_pasteMenuItem.setVisible(this.m_isEditable);
                }
                if (this.m_mapSeparator1 != null) {
                    this.m_mapSeparator1.setVisible(this.m_isEditable);
                }
                if (this.m_newMenu != null) {
                    this.m_newMenu.setVisible(this.m_isEditable);
                }
                boolean bShowTextAnnotations = this.m_vwMapNodeUIToolkit.getMapAttribs().isTextAnnotationsVisible();
                if (this.m_mapSeparator2 != null) {
                    this.m_mapSeparator2.setVisible(bShowTextAnnotations);
                }
                if (this.m_newTextAnnotationMenuItem != null) {
                    this.m_newTextAnnotationMenuItem.setVisible(bShowTextAnnotations);
                }
                if ((mapNames = ((VWDesignerWorkflowPane)this.m_workflowPane).getMaps()) != null) {
                    int mapNameSize = mapNames.length;
                    if (mapNameSize > 1) {
                        this.m_mapsMenu.setEnabled(true);
                        this.m_mapsMenu.removeAll();
                        for (int i = 0; i < mapNameSize; ++i) {
                            JMenuItem menuItem = new JMenuItem(mapNames[i]);
                            menuItem.addActionListener(this);
                            this.m_mapsMenu.add(menuItem);
                        }
                    } else {
                        this.m_mapsMenu.setEnabled(false);
                    }
                } else {
                    this.m_mapsMenu.setEnabled(false);
                }
                String[] callerMapNames = this.getParentMapNames();
                if (callerMapNames != null) {
                    int callerMapNameSize = callerMapNames.length;
                    if (callerMapNameSize > 0) {
                        this.m_callerMapsMenu.setEnabled(true);
                        this.m_callerMapsMenu.removeAll();
                        for (int i = 0; i < callerMapNameSize; ++i) {
                            JMenuItem menuItem = new JMenuItem(callerMapNames[i]);
                            menuItem.addActionListener(this);
                            this.m_callerMapsMenu.add(menuItem);
                        }
                    } else {
                        this.m_callerMapsMenu.setEnabled(false);
                    }
                } else {
                    this.m_callerMapsMenu.setEnabled(false);
                }
                if (this.m_mapSeparator3 != null) {
                    this.m_mapSeparator3.setVisible(this.m_isEditable);
                }
                if (this.m_deleteCurrentMapMenuItem != null) {
                    this.m_deleteCurrentMapMenuItem.setVisible(this.m_isEditable);
                }
                this.m_mapMenu.show(event.getComponent(), event.getX(), event.getY());
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void addNewStepUI(VWBaseStepUI stepUI, Point loc) {
        stepUI.setComponentOrientation(this.getComponentOrientation());
        this.m_steps.addElement(stepUI);
        this.focusGained(new FocusEvent(stepUI, 1004));
        stepUI.setFocus(false);
        this.mouseClicked(new MouseEvent(this, 500, 0L, 0, loc.x, loc.y, 1, false));
        stepUI.addFocusListener(this);
        this.recalculateBounds(0);
        this.repaint(stepUI.getBounds());
        this.setIsDirty(true);
    }

    private VWBaseStepUI createNewGeneralStep(Point loc) {
        VWGeneralStepUI step = null;
        this.clearAllSelectedItems(false);
        try {
            VWStepDefinition vwStep;
            if (this.m_map.getMapDefinition() != null && (vwStep = this.m_map.getMapDefinition().createStep(VWResource.s_general)) != null) {
                vwStep.setLocation(loc);
                VWStepUtils.setStepType(vwStep, new Integer(2));
                step = new VWGeneralStepUI(vwStep, this.m_vwMapNodeUIToolkit);
                Object[] steps = new Object[]{vwStep};
                this.notifyOfItemsAdded(steps);
                this.addNewStepUI(step, loc);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), VWResource.s_error, 1);
        }
        return step;
    }

    private VWBaseStepUI createNewGeneralStep(VWStepDefinition vwStep) {
        VWGeneralStepUI step = null;
        try {
            if (this.m_map.getMapDefinition() != null && vwStep != null) {
                Point loc = vwStep.getLocation();
                step = new VWGeneralStepUI(vwStep, vwStep.getStepId() == 0, this.m_vwMapNodeUIToolkit);
                Object[] steps = new Object[]{vwStep};
                this.notifyOfItemsAdded(steps);
                this.addNewStepUI(step, loc);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), VWResource.s_error, 1);
        }
        return step;
    }

    private VWBaseStepUI createNewSystemStep(Point loc) {
        VWSystemStepUI step = null;
        this.clearAllSelectedItems(false);
        try {
            VWCompoundStepDefinition vwStep;
            if (this.m_map.getMapDefinition() != null && (vwStep = this.m_map.getMapDefinition().createCompoundStep(VWResource.s_system)) != null) {
                vwStep.setLocation(loc);
                VWStepUtils.setStepType(vwStep, new Integer(6));
                step = new VWSystemStepUI(vwStep, this.m_vwMapNodeUIToolkit);
                Object[] steps = new Object[]{vwStep};
                this.notifyOfItemsAdded(steps);
                this.addNewStepUI(step, loc);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), VWResource.s_error, 1);
        }
        return step;
    }

    private VWBaseStepUI createNewSystemStep(VWCompoundStepDefinition vwStep) {
        VWSystemStepUI step = null;
        try {
            if (this.m_map.getMapDefinition() != null && vwStep != null) {
                Point loc = vwStep.getLocation();
                step = new VWSystemStepUI(vwStep, vwStep.getStepId() == 0, this.m_vwMapNodeUIToolkit);
                Object[] steps = new Object[]{vwStep};
                this.notifyOfItemsAdded(steps);
                this.addNewStepUI(step, loc);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), VWResource.s_error, 1);
        }
        return step;
    }

    private VWBaseStepUI createNewCallStep(Point loc) {
        VWSubmapStepUI step = null;
        this.clearAllSelectedItems(false);
        try {
            VWCompoundStepDefinition vwStep;
            if (this.m_map.getMapDefinition() != null && (vwStep = this.m_map.getMapDefinition().createCompoundStep(VWResource.s_submap)) != null) {
                vwStep.setLocation(loc);
                vwStep.createCallInstruction(null);
                VWStepUtils.setStepType(vwStep, new Integer(4));
                step = new VWSubmapStepUI(vwStep, this.m_vwMapNodeUIToolkit);
                Object[] steps = new Object[]{vwStep};
                this.notifyOfItemsAdded(steps);
                this.addNewStepUI(step, loc);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), VWResource.s_error, 1);
        }
        return step;
    }

    private VWBaseStepUI createNewCallStep(VWCompoundStepDefinition vwStep) {
        VWSubmapStepUI step = null;
        try {
            if (this.m_map.getMapDefinition() != null && vwStep != null) {
                Point loc = vwStep.getLocation();
                step = new VWSubmapStepUI(vwStep, vwStep.getStepId() == 0, this.m_vwMapNodeUIToolkit);
                Object[] steps = new Object[]{vwStep};
                this.notifyOfItemsAdded(steps);
                this.addNewStepUI(step, loc);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), VWResource.s_error, 1);
        }
        return step;
    }

    private VWBaseStepUI createNewComponentStep(Point loc) {
        this.clearAllSelectedItems(false);
        try {
            VWCompoundStepDefinition vwStep;
            if (this.m_map.getMapDefinition() != null && (vwStep = this.m_map.getMapDefinition().createCompoundStep(VWResource.s_component)) != null) {
                vwStep.setLocation(loc);
                VWStepUtils.setStepType(vwStep, new Integer(8));
                return this.createNewComponentStep(vwStep);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), VWResource.s_error, 1);
        }
        return null;
    }

    private VWBaseStepUI createNewComponentStep(VWCompoundStepDefinition vwStep) {
        VWComponentStepUI step = null;
        try {
            if (this.m_map.getMapDefinition() != null && vwStep != null) {
                Point loc = vwStep.getLocation();
                step = new VWComponentStepUI(vwStep, vwStep.getStepId() == 0, this.m_vwMapNodeUIToolkit);
                Object[] steps = new Object[]{vwStep};
                this.notifyOfItemsAdded(steps);
                this.addNewStepUI(step, loc);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), VWResource.s_error, 1);
        }
        return step;
    }

    private VWBaseRouteUI createNewRoute(VWBaseStepUI srcStep, VWBaseStepUI destStep) throws VWException {
        VWBaseRouteUI routeUI = null;
        if (!srcStep.hasARouteToStep(destStep)) {
            this.clearAllSelectedItems(false);
            routeUI = destStep.hasARouteToStep(srcStep) ? new VWBaseRouteUI(srcStep.getMapNode().createRoute(destStep.getMapNode().getStepId()), srcStep, destStep, true, 2, this.m_stepRouteColors, this.m_workflowPane.getMapAttributes()) : new VWBaseRouteUI(srcStep.getMapNode().createRoute(destStep.getMapNode().getStepId()), srcStep, destStep, true, 1, this.m_stepRouteColors, this.m_workflowPane.getMapAttributes());
            routeUI.addFocusListener(this);
            srcStep.addNextRoute(routeUI, destStep);
            destStep.addPrevRoute(routeUI, srcStep);
            this.repaint(routeUI.getBounds());
            this.m_routes.addElement(routeUI);
            Object[] routes = new Object[]{routeUI.getRouteDefinition()};
            this.notifyOfItemsAdded(routes);
            this.notifySelectListeners(true);
        }
        return routeUI;
    }

    private VWBaseRouteUI findRoute(int nRouteId) {
        for (int nIndex = 0; nIndex < this.m_routes.size(); ++nIndex) {
            if (((VWBaseRouteUI)this.m_routes.elementAt(nIndex)).getRouteDefinition().getRouteId() != nRouteId) continue;
            return (VWBaseRouteUI)this.m_routes.elementAt(nIndex);
        }
        return null;
    }

    private void createNewAssociation(VWBaseTextAnnotationUI srcTextAnnotation, Object targetUI, boolean bBroadcast) throws VWException {
        VWBaseRouteUI targetRoute;
        VWBaseAssociationUI associationUI = null;
        if (targetUI instanceof VWBaseStepUI) {
            VWBaseStepUI targetStep = (VWBaseStepUI)targetUI;
            if (!srcTextAnnotation.hasAnAnnotationToItem(targetStep)) {
                VWAssociationDefinition associationDefinition = srcTextAnnotation.getDefinition().createAssociation(targetStep.getMapNode().getStepId(), 1);
                associationUI = new VWBaseAssociationUI(associationDefinition, srcTextAnnotation, targetStep, this.m_stepRouteColors, this.m_workflowPane.getMapAttributes());
                srcTextAnnotation.addAssociation(associationUI, targetStep);
                targetStep.addAssociation(associationUI, srcTextAnnotation);
            }
        } else if (targetUI instanceof VWBaseRouteUI && !srcTextAnnotation.hasAnAnnotationToItem(targetRoute = (VWBaseRouteUI)targetUI)) {
            VWAssociationDefinition associationDefinition = srcTextAnnotation.getDefinition().createAssociation(targetRoute.getRouteDefinition().getRouteId(), 2);
            associationUI = new VWBaseAssociationUI(associationDefinition, srcTextAnnotation, targetRoute, this.m_stepRouteColors, this.m_workflowPane.getMapAttributes());
            srcTextAnnotation.addAssociation(associationUI, targetRoute);
            targetRoute.addAssociation(associationUI, srcTextAnnotation);
        }
        if (associationUI != null) {
            this.m_associations.addElement(associationUI);
            if (bBroadcast) {
                this.clearAllSelectedItems(false);
                Object[] associations = new Object[]{associationUI.getDefinition()};
                this.notifyOfItemsAdded(associations);
                associationUI.setFocus(true);
            }
            associationUI.addFocusListener(this);
            this.repaint(associationUI.getBounds());
            if (bBroadcast) {
                this.notifySelectListeners(true);
            }
            this.setIsDirty(true);
        }
    }

    private void copySelectedStepsToXML(boolean bDeleteSelected, StringBuffer xmlStream) {
        Vector<VWBaseStepUI> selectedSteps = new Vector<VWBaseStepUI>();
        try {
            for (int nIndex = 0; nIndex < this.m_steps.size(); ++nIndex) {
                VWBaseStepUI step = (VWBaseStepUI)this.m_steps.elementAt(nIndex);
                if (!step.getSelect() || step.getStepType() == 0) continue;
                if (xmlStream != null) {
                    step.getMapNode().toXML(xmlStream);
                }
                if (!bDeleteSelected) continue;
                selectedSteps.addElement(step);
            }
            if (bDeleteSelected) {
                this.deleteSelectedSteps(selectedSteps);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), VWResource.s_error, 1);
            xmlStream = null;
            selectedSteps.removeAllElements();
        }
    }

    private void deleteSelectedSteps(Vector selectedSteps) {
        try {
            VWBaseAssociationUI associationUI;
            Enumeration myEnum;
            int nIndex;
            if (selectedSteps == null) {
                return;
            }
            Vector<Object> removedItems = new Vector<Object>();
            for (nIndex = 0; nIndex < selectedSteps.size(); ++nIndex) {
                VWBaseAssociationUI associationUI2;
                Enumeration myEnum2;
                VWBaseRouteUI routeUI;
                VWBaseStepUI stepUI = (VWBaseStepUI)selectedSteps.elementAt(nIndex);
                if (!stepUI.getSelect() || stepUI.getStepType() == 0 || stepUI.isStartStep()) continue;
                this.m_steps.removeElement(stepUI);
                removedItems.addElement(stepUI.getMapNode());
                this.m_map.getMapDefinition().deleteStep(stepUI.getMapNode().getStepId());
                this.invalidStepRegion(stepUI);
                stepUI.removeFocusListener(this);
                Enumeration e = stepUI.getPrevRoutes();
                while (e.hasMoreElements()) {
                    routeUI = (VWBaseRouteUI)e.nextElement();
                    if (!selectedSteps.contains(routeUI.getSrcStep())) {
                        stepUI.removePrevRoute(routeUI);
                        routeUI.getSrcStep().removeNextRoute(routeUI);
                    }
                    this.m_routes.removeElement(routeUI);
                    removedItems.addElement(routeUI.getRouteDefinition());
                    routeUI.removeFocusListener(this);
                    myEnum2 = routeUI.getAssociations();
                    while (myEnum2.hasMoreElements()) {
                        associationUI2 = (VWBaseAssociationUI)myEnum2.nextElement();
                        associationUI2.getSourceTextAnnotation().removeAssociation(associationUI2);
                        this.m_associations.removeElement(associationUI2);
                        removedItems.addElement(associationUI2.getDefinition());
                    }
                }
                e = stepUI.getNextRoutes();
                while (e.hasMoreElements()) {
                    routeUI = (VWBaseRouteUI)e.nextElement();
                    if (!selectedSteps.contains(routeUI.getDestStep())) {
                        stepUI.removeNextRoute(routeUI);
                        routeUI.getDestStep().removePrevRoute(routeUI);
                    }
                    this.m_routes.removeElement(routeUI);
                    removedItems.addElement(routeUI.getRouteDefinition());
                    routeUI.removeFocusListener(this);
                    myEnum2 = routeUI.getAssociations();
                    while (myEnum2.hasMoreElements()) {
                        associationUI2 = (VWBaseAssociationUI)myEnum2.nextElement();
                        associationUI2.getSourceTextAnnotation().removeAssociation(associationUI2);
                        this.m_associations.removeElement(associationUI2);
                        removedItems.addElement(associationUI2.getDefinition());
                    }
                }
                myEnum = stepUI.getAssociations();
                while (myEnum.hasMoreElements()) {
                    associationUI = (VWBaseAssociationUI)myEnum.nextElement();
                    associationUI.getSourceTextAnnotation().removeAssociation(associationUI);
                    this.m_associations.removeElement(associationUI);
                    removedItems.addElement(associationUI.getDefinition());
                }
            }
            for (nIndex = 0; nIndex < this.m_routes.size(); ++nIndex) {
                VWBaseRouteUI routeUI = (VWBaseRouteUI)this.m_routes.elementAt(nIndex);
                if (!routeUI.getSelect()) continue;
                this.m_routes.removeElementAt(nIndex);
                removedItems.addElement(routeUI.getRouteDefinition());
                routeUI.getSrcStep().getMapNode().deleteRoute(routeUI.getRouteDefinition().getRouteId());
                routeUI.removeFocusListener(this);
                routeUI.getSrcStep().removeNextRoute(routeUI);
                routeUI.getDestStep().removePrevRoute(routeUI);
                myEnum = routeUI.getAssociations();
                while (myEnum.hasMoreElements()) {
                    associationUI = (VWBaseAssociationUI)myEnum.nextElement();
                    associationUI.getSourceTextAnnotation().removeAssociation(associationUI);
                    this.m_associations.removeElement(associationUI);
                    removedItems.addElement(associationUI.getDefinition());
                }
                this.repaint(routeUI.getBounds());
            }
            if (!removedItems.isEmpty()) {
                Object[] items = new Object[removedItems.size()];
                removedItems.copyInto(items);
                this.notifyOfItemsRemoved(items);
                this.notifySelectListeners(false);
            }
            this.m_dragItems = null;
            this.recalculateBounds(0);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), VWResource.s_error, 1);
        }
    }

    private void copySelectedTextAnnotationsToXML(boolean bDeleteSelected, StringBuffer xmlStream) {
        Vector<VWBaseTextAnnotationUI> selectedTextAnnotations = new Vector<VWBaseTextAnnotationUI>();
        try {
            for (int nIndex = 0; nIndex < this.m_textAnnotations.size(); ++nIndex) {
                VWBaseTextAnnotationUI textAnnotationUI = (VWBaseTextAnnotationUI)this.m_textAnnotations.elementAt(nIndex);
                if (!textAnnotationUI.getSelect()) continue;
                if (xmlStream != null) {
                    textAnnotationUI.getDefinition().toXML(xmlStream);
                }
                if (!bDeleteSelected) continue;
                selectedTextAnnotations.addElement(textAnnotationUI);
            }
            if (bDeleteSelected) {
                this.deleteSelectedTextAnnotations(selectedTextAnnotations);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), VWResource.s_error, 1);
            xmlStream = null;
            selectedTextAnnotations.removeAllElements();
        }
    }

    private void deleteSelectedTextAnnotations(Vector selectedTextAnnotations) {
        try {
            int nIndex;
            if (selectedTextAnnotations == null) {
                return;
            }
            Vector<Cloneable> removedItems = new Vector<Cloneable>();
            for (nIndex = 0; nIndex < selectedTextAnnotations.size(); ++nIndex) {
                VWBaseTextAnnotationUI textAnnotationUI = (VWBaseTextAnnotationUI)selectedTextAnnotations.elementAt(nIndex);
                if (!textAnnotationUI.getSelect()) continue;
                this.m_textAnnotations.removeElement(textAnnotationUI);
                removedItems.addElement(textAnnotationUI.getDefinition());
                this.m_map.getMapDefinition().deleteTextAnnotation(textAnnotationUI.getDefinition().getId());
                this.invalidateTextAnnotationRegion(textAnnotationUI);
                textAnnotationUI.removeFocusListener(this);
                Enumeration myEnum = textAnnotationUI.getAssociations();
                while (myEnum.hasMoreElements()) {
                    VWBaseAssociationUI associationUI = (VWBaseAssociationUI)myEnum.nextElement();
                    switch (associationUI.getDefinition().getTargetType()) {
                        case 1: {
                            VWBaseStepUI stepUI = (VWBaseStepUI)associationUI.getTargetItem();
                            stepUI.removeAssociation(associationUI);
                            break;
                        }
                        case 2: {
                            VWBaseRouteUI routeUI = (VWBaseRouteUI)associationUI.getTargetItem();
                            routeUI.removeAssociation(associationUI);
                            break;
                        }
                    }
                    this.m_associations.removeElement(associationUI);
                    removedItems.addElement(associationUI.getDefinition());
                    associationUI.removeFocusListener(this);
                }
            }
            for (nIndex = this.m_associations.size() - 1; nIndex >= 0; --nIndex) {
                VWBaseAssociationUI associationUI = (VWBaseAssociationUI)this.m_associations.elementAt(nIndex);
                if (!associationUI.getSelect()) continue;
                this.m_associations.removeElementAt(nIndex);
                removedItems.addElement(associationUI.getDefinition());
                associationUI.getSourceTextAnnotation().removeAssociation(associationUI);
                associationUI.getSourceTextAnnotation().getDefinition().deleteAssociation(associationUI.getDefinition().getTargetId(), associationUI.getDefinition().getTargetType());
                associationUI.removeFocusListener(this);
                switch (associationUI.getDefinition().getTargetType()) {
                    case 1: {
                        VWBaseStepUI stepUI = (VWBaseStepUI)associationUI.getTargetItem();
                        stepUI.removeAssociation(associationUI);
                        break;
                    }
                    case 2: {
                        VWBaseRouteUI routeUI = (VWBaseRouteUI)associationUI.getTargetItem();
                        routeUI.removeAssociation(associationUI);
                        break;
                    }
                }
                this.repaint(associationUI.getBounds());
            }
            if (!removedItems.isEmpty()) {
                Object[] items = new Object[removedItems.size()];
                removedItems.copyInto(items);
                this.notifyOfItemsRemoved(items);
                this.notifySelectListeners(false);
            }
            this.m_dragItems = null;
            this.recalculateBounds(0);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), VWResource.s_error, 1);
        }
    }

    private Cursor getStepSelectCursor() {
        if (this.m_stepSelectCursor == null) {
            this.m_stepSelectCursor = this.loadCursor("images/stepselectcursor.gif");
        }
        return this.m_stepSelectCursor;
    }

    private Cursor getRouteDragCursor() {
        if (this.m_routeDragCursor == null) {
            this.m_routeDragCursor = this.loadCursor("images/routedragcursor.gif");
        }
        return this.m_routeDragCursor;
    }

    private Cursor getRouteSelectCursor() {
        if (this.m_routeSelectCursor == null) {
            this.m_routeSelectCursor = this.loadCursor("images/routeselectcursor.gif");
        }
        return this.m_routeSelectCursor;
    }

    private Cursor getTextAnnotationSelectCursor() {
        if (this.m_textAnnotationSelectCursor == null) {
            this.m_textAnnotationSelectCursor = this.loadCursor("images/textAnnotationSelectCursor.gif");
        }
        return this.m_textAnnotationSelectCursor;
    }

    private Cursor getAssociationDragCursor() {
        if (this.m_associationDragCursor == null) {
            this.m_associationDragCursor = this.loadCursor("images/associationDragCursor.gif");
        }
        return this.m_associationDragCursor;
    }

    private Cursor getAssociationSelectCursor() {
        if (this.m_associationSelectCursor == null) {
            this.m_associationSelectCursor = this.loadCursor("images/associationSelectCursor.gif");
        }
        return this.m_associationSelectCursor;
    }

    private Cursor getSelectorCursor() {
        if (this.m_selectorCursor == null) {
            this.m_selectorCursor = this.loadCursor("images/selectorcursor.gif");
        }
        return this.m_selectorCursor;
    }

    private Cursor loadCursor(String filePath) {
        try {
            URL url = VWDesignerWorkflowMapPane.class.getResource(filePath);
            Image image = Toolkit.getDefaultToolkit().getImage(url);
            return Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(0, 0), "");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    private void replaceStepUI(VWBaseStepUI newStepUI) {
        try {
            int nStepID = newStepUI.getMapNode().getStepId();
            for (int i = 0; i < this.m_steps.size(); ++i) {
                VWBaseStepUI oldStepUI = (VWBaseStepUI)this.m_steps.elementAt(i);
                if (oldStepUI == newStepUI || oldStepUI.getMapNode().getStepId() != nStepID) continue;
                oldStepUI.replace(newStepUI);
                this.m_steps.removeElement(oldStepUI);
                Object[] removedStepUI = new Object[]{oldStepUI.getMapNode()};
                this.notifyOfItemsRemoved(removedStepUI);
                break;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), VWResource.s_error, 1);
        }
    }

    private VWBaseStepUI changeToGeneralStep(VWMapNode mapNode) {
        VWStepDefinition newMapNode = null;
        VWBaseStepUI newStepUI = null;
        try {
            int oldStepType = VWStepUtils.getStepType(mapNode);
            if (mapNode != null && !VWStepUtils.isGeneralStep(oldStepType) && !VWStepUtils.isStartGeneralStep(oldStepType)) {
                newMapNode = (VWStepDefinition)this.m_map.getMapDefinition().changeStepType(mapNode.getStepId());
                VWStepUtils.setStepType(newMapNode, new Integer(2));
                newStepUI = this.createNewGeneralStep(newMapNode);
                this.replaceStepUI(newStepUI);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), VWResource.s_error, 1);
        }
        return newStepUI;
    }

    private VWBaseStepUI changeToCallStep(VWMapNode mapNode) {
        VWCompoundStepDefinition newMapNode = null;
        VWBaseStepUI newStepUI = null;
        try {
            int oldStepType = VWStepUtils.getStepType(mapNode);
            if (mapNode != null && oldStepType != 9 && oldStepType != 10) {
                if (oldStepType == 11 || oldStepType == 12 || oldStepType == 13 || oldStepType == 14) {
                    VWAttributeInfo vwAttributeInfo;
                    VWInstructionDefinition[] instructionDefs;
                    if (mapNode instanceof VWCompoundStepDefinition && (instructionDefs = (newMapNode = (VWCompoundStepDefinition)mapNode).getInstructions()) != null) {
                        int size = instructionDefs.length;
                        for (int i = 0; i < size; ++i) {
                            newMapNode.deleteInstruction(instructionDefs[i].getInstructionId());
                        }
                    }
                    if ((vwAttributeInfo = mapNode.getAttributeInfo()) != null) {
                        vwAttributeInfo.deleteField("UI_IconName");
                        vwAttributeInfo.deleteField("UI_StepPropertiesPanelClass");
                    }
                } else {
                    newMapNode = (VWCompoundStepDefinition)this.m_map.getMapDefinition().changeStepType(mapNode.getStepId());
                }
                if (newMapNode != null) {
                    VWStepUtils.setStepType(newMapNode, new Integer(4));
                    newMapNode.createCallInstruction(null);
                    newStepUI = this.createNewCallStep(newMapNode);
                    this.replaceStepUI(newStepUI);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), VWResource.s_error, 1);
        }
        return newStepUI;
    }

    private VWBaseStepUI changeToSystemStep(VWMapNode mapNode) {
        VWCompoundStepDefinition newMapNode = null;
        VWBaseStepUI newStepUI = null;
        try {
            int oldStepType = VWStepUtils.getStepType(mapNode);
            if (mapNode != null && oldStepType != 11 && oldStepType != 12) {
                if (oldStepType == 9 || oldStepType == 10 || oldStepType == 13 || oldStepType == 14) {
                    VWAttributeInfo vwAttributeInfo;
                    VWInstructionDefinition[] instructionDefs;
                    if (mapNode instanceof VWCompoundStepDefinition && (instructionDefs = (newMapNode = (VWCompoundStepDefinition)mapNode).getInstructions()) != null) {
                        int size = instructionDefs.length;
                        for (int i = 0; i < size; ++i) {
                            newMapNode.deleteInstruction(instructionDefs[i].getInstructionId());
                        }
                    }
                    if ((vwAttributeInfo = mapNode.getAttributeInfo()) != null) {
                        vwAttributeInfo.deleteField("UI_IconName");
                        vwAttributeInfo.deleteField("UI_StepPropertiesPanelClass");
                    }
                } else {
                    newMapNode = (VWCompoundStepDefinition)this.m_map.getMapDefinition().changeStepType(mapNode.getStepId());
                }
                VWStepUtils.setStepType(newMapNode, new Integer(6));
                newStepUI = this.createNewSystemStep(newMapNode);
                this.replaceStepUI(newStepUI);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), VWResource.s_error, 1);
        }
        return newStepUI;
    }

    private VWBaseStepUI changeToComponentStep(VWMapNode mapNode) {
        VWCompoundStepDefinition newMapNode = null;
        VWBaseStepUI newStepUI = null;
        try {
            int oldStepType = VWStepUtils.getStepType(mapNode);
            if (mapNode != null && oldStepType != 13 && oldStepType != 14) {
                if (oldStepType == 11 || oldStepType == 12 || oldStepType == 9 || oldStepType == 10) {
                    VWAttributeInfo vwAttributeInfo;
                    VWInstructionDefinition[] instructionDefs;
                    if (mapNode instanceof VWCompoundStepDefinition && (instructionDefs = (newMapNode = (VWCompoundStepDefinition)mapNode).getInstructions()) != null) {
                        int size = instructionDefs.length;
                        for (int i = 0; i < size; ++i) {
                            newMapNode.deleteInstruction(instructionDefs[i].getInstructionId());
                        }
                    }
                    if ((vwAttributeInfo = mapNode.getAttributeInfo()) != null) {
                        vwAttributeInfo.deleteField("UI_IconName");
                        vwAttributeInfo.deleteField("UI_StepPropertiesPanelClass");
                    }
                } else {
                    newMapNode = (VWCompoundStepDefinition)this.m_map.getMapDefinition().changeStepType(mapNode.getStepId());
                }
                if (newMapNode != null) {
                    VWStepUtils.setStepType(newMapNode, new Integer(8));
                    newStepUI = this.createNewComponentStep(newMapNode);
                    this.replaceStepUI(newStepUI);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), VWResource.s_error, 1);
        }
        return newStepUI;
    }

    private void performGotoMapAction() {
        Object[] selectedObjects = this.getSelectedObjects();
        if (selectedObjects != null && selectedObjects.length > 0) {
            String mapName = VWStepUtils.getCalledMapName((VWMapNode)selectedObjects[0]);
            this.m_workflowPane.getToolbarActionNotifier().notifyToolbarAction(this, 503, mapName);
        }
    }

    private void performReverseRouteDirectionAction() {
        try {
            for (int nIndex = 0; nIndex < this.m_routes.size(); ++nIndex) {
                VWBaseRouteUI newRouteUI;
                VWBaseRouteUI routeUI = (VWBaseRouteUI)this.m_routes.elementAt(nIndex);
                if (!routeUI.getFocus()) continue;
                Vector<Cloneable> removedItems = new Vector<Cloneable>();
                VWRouteDefinition oldRouteDef = routeUI.getRouteDefinition();
                this.m_routes.removeElementAt(nIndex);
                removedItems.addElement(oldRouteDef);
                VWBaseStepUI oldSourceStepUI = routeUI.getSrcStep();
                VWBaseStepUI oldDestinationStepUI = routeUI.getDestStep();
                oldSourceStepUI.getMapNode().deleteRoute(oldRouteDef.getRouteId());
                routeUI.removeFocusListener(this);
                oldSourceStepUI.removeNextRoute(routeUI);
                oldDestinationStepUI.removePrevRoute(routeUI);
                Vector<VWBaseTextAnnotationUI> textAnnotationUIList = new Vector<VWBaseTextAnnotationUI>();
                Enumeration myEnum = routeUI.getAssociations();
                while (myEnum.hasMoreElements()) {
                    VWBaseAssociationUI associationUI = (VWBaseAssociationUI)myEnum.nextElement();
                    VWBaseTextAnnotationUI textAnnotationUI = associationUI.getSourceTextAnnotation();
                    textAnnotationUIList.addElement(textAnnotationUI);
                    textAnnotationUI.removeAssociation(associationUI);
                    this.m_associations.removeElement(associationUI);
                    removedItems.addElement(associationUI.getDefinition());
                }
                this.repaint(routeUI.getBounds());
                if (!removedItems.isEmpty()) {
                    Object[] items = new Object[removedItems.size()];
                    removedItems.copyInto(items);
                    this.notifyOfItemsRemoved(items);
                    this.notifySelectListeners(false);
                }
                if ((newRouteUI = this.createNewRoute(oldDestinationStepUI, oldSourceStepUI)) != null) {
                    VWRouteDefinition newRouteDef = newRouteUI.getRouteDefinition();
                    newRouteDef.setAttributeInfo(oldRouteDef.getAttributeInfo());
                    newRouteDef.setCondition(oldRouteDef.getCondition());
                    newRouteDef.setDescription(oldRouteDef.getDescription());
                    newRouteDef.setName(oldRouteDef.getName());
                    for (int nListIndex = 0; nListIndex < textAnnotationUIList.size(); ++nListIndex) {
                        VWBaseTextAnnotationUI textAnnotationUI = (VWBaseTextAnnotationUI)textAnnotationUIList.elementAt(nListIndex);
                        this.createNewAssociation(textAnnotationUI, newRouteUI, false);
                    }
                    this.notifySelectListeners(true);
                }
                break;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), VWResource.s_error, 1);
        }
    }

    private void performOpenPropertiesAction() {
        Object[] selectedObjects = this.getSelectedObjects();
        if (selectedObjects != null && selectedObjects.length > 0) {
            this.m_workflowPane.getToolbarActionNotifier().notifyToolbarAction(this, 670, selectedObjects);
            this.notifySelectListeners(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMapAfterPaste(IVWPastable[] vwPastableItems, Point pasteOrigin) {
        try {
            try {
                Vector<Cloneable> newVWItems;
                this.setCursor(Cursor.getPredefinedCursor(3));
                if (vwPastableItems != null && vwPastableItems.length > 0) {
                    VWBaseRouteUI routeUI;
                    int nIndex;
                    VWBaseTextAnnotationUI textAnnotationUI;
                    VWBaseStepUI stepUI;
                    Point deltaPt = new Point(0, 0);
                    newVWItems = new Vector<Cloneable>();
                    Vector<VWBaseStepUI> newSteps = new Vector<VWBaseStepUI>();
                    Vector<VWBaseTextAnnotationUI> newTextAnnotations = new Vector<VWBaseTextAnnotationUI>();
                    this.clearAllSelectedItems(false);
                    for (int nIndex2 = 0; nIndex2 < vwPastableItems.length; ++nIndex2) {
                        if (vwPastableItems[nIndex2] instanceof VWMapNode) {
                            VWMapNode newMapNode = (VWMapNode)vwPastableItems[nIndex2];
                            stepUI = null;
                            VWStepUtils.getAttributeStepType(newMapNode, true);
                            int nNewStepType = VWStepUtils.getStepType(newMapNode);
                            switch (nNewStepType) {
                                case 1: 
                                case 3: 
                                case 5: {
                                    stepUI = new VWGeneralStepUI((VWStepDefinition)newMapNode, this.m_vwMapNodeUIToolkit);
                                    break;
                                }
                                case 9: {
                                    stepUI = new VWSubmapStepUI((VWCompoundStepDefinition)newMapNode, this.m_vwMapNodeUIToolkit);
                                    break;
                                }
                                case 11: {
                                    stepUI = new VWSystemStepUI((VWCompoundStepDefinition)newMapNode, this.m_vwMapNodeUIToolkit);
                                    break;
                                }
                                case 13: {
                                    stepUI = new VWComponentStepUI((VWCompoundStepDefinition)newMapNode, this.m_vwMapNodeUIToolkit);
                                    break;
                                }
                                default: {
                                    VWDebug.logError("Invalid step type: " + nNewStepType + " - unable to paste.");
                                }
                            }
                            if (stepUI == null) continue;
                            Point stepLoc = stepUI.getLocation();
                            if (nIndex2 == 0) {
                                deltaPt.setLocation(stepLoc);
                            } else {
                                if (stepLoc.x < deltaPt.x) {
                                    deltaPt.x = stepLoc.x;
                                }
                                if (stepLoc.y < deltaPt.y) {
                                    deltaPt.y = stepLoc.y;
                                }
                            }
                            stepUI.setComponentOrientation(this.getComponentOrientation());
                            this.m_steps.addElement(stepUI);
                            newSteps.addElement(stepUI);
                            newVWItems.addElement(newMapNode);
                            stepUI.addFocusListener(this);
                            stepUI.setSelect(true);
                            continue;
                        }
                        if (!(vwPastableItems[nIndex2] instanceof VWTextAnnotationDefinition)) continue;
                        VWTextAnnotationDefinition vwTextAnnotation = (VWTextAnnotationDefinition)vwPastableItems[nIndex2];
                        textAnnotationUI = new VWBaseTextAnnotationUI(vwTextAnnotation, this.m_stepRouteColors, this.m_vwMapNodeUIToolkit.getMapAttribs());
                        textAnnotationUI.setComponentOrientation(this.getComponentOrientation());
                        Point locPt = textAnnotationUI.getLocation();
                        if (nIndex2 == 0) {
                            deltaPt.setLocation(locPt);
                        } else {
                            if (locPt.x < deltaPt.x) {
                                deltaPt.x = locPt.x;
                            }
                            if (locPt.y < deltaPt.y) {
                                deltaPt.y = locPt.y;
                            }
                        }
                        this.m_textAnnotations.addElement(textAnnotationUI);
                        newTextAnnotations.addElement(textAnnotationUI);
                        newVWItems.addElement(vwTextAnnotation);
                        textAnnotationUI.addFocusListener(this);
                        textAnnotationUI.setSelect(true);
                    }
                    if (pasteOrigin == null) {
                        if (this.getParent() instanceof JViewport) {
                            JViewport viewport = (JViewport)this.getParent();
                            pasteOrigin = viewport.getViewPosition();
                        } else {
                            pasteOrigin = new Point(0, 0);
                        }
                    }
                    deltaPt.x = pasteOrigin.x - deltaPt.x;
                    deltaPt.y = pasteOrigin.y - deltaPt.y;
                    boolean bSetFocusItem = false;
                    for (nIndex = 0; nIndex < newSteps.size(); ++nIndex) {
                        VWRouteDefinition[] vwRoutes;
                        stepUI = (VWBaseStepUI)newSteps.elementAt(nIndex);
                        if (stepUI == null) continue;
                        Point stepLoc = stepUI.getLocation();
                        stepLoc.translate(deltaPt.x, deltaPt.y);
                        stepUI.setLocation(stepLoc);
                        if (nIndex == 0) {
                            stepUI.setFocus(true);
                            bSetFocusItem = true;
                        }
                        if ((vwRoutes = stepUI.getMapNode().getNextRoutes()) == null) continue;
                        for (int rIndex = 0; rIndex < vwRoutes.length; ++rIndex) {
                            VWBaseStepUI nextStepUI = this.findStep(vwRoutes[rIndex].getDestinationStep());
                            routeUI = null;
                            routeUI = nextStepUI.hasARouteToStep(stepUI) ? new VWBaseRouteUI(vwRoutes[rIndex], stepUI, nextStepUI, false, 2, this.m_stepRouteColors, this.m_workflowPane.getMapAttributes()) : new VWBaseRouteUI(vwRoutes[rIndex], stepUI, nextStepUI, false, 1, this.m_stepRouteColors, this.m_workflowPane.getMapAttributes());
                            stepUI.addNextRoute(routeUI, nextStepUI);
                            nextStepUI.addPrevRoute(routeUI, stepUI);
                            this.m_routes.addElement(routeUI);
                            newVWItems.addElement(vwRoutes[rIndex]);
                            this.repaint(routeUI.getBounds());
                            routeUI.addFocusListener(this);
                            routeUI.setSelect(true);
                        }
                    }
                    for (nIndex = 0; nIndex < newTextAnnotations.size(); ++nIndex) {
                        VWAssociationDefinition[] vwAssociations;
                        textAnnotationUI = (VWBaseTextAnnotationUI)newTextAnnotations.elementAt(nIndex);
                        if (textAnnotationUI == null) continue;
                        Point locPt = textAnnotationUI.getLocation();
                        locPt.translate(deltaPt.x, deltaPt.y);
                        textAnnotationUI.setLocation(locPt);
                        if (!bSetFocusItem && nIndex == 0) {
                            textAnnotationUI.setFocus(true);
                            bSetFocusItem = true;
                        }
                        if ((vwAssociations = textAnnotationUI.getDefinition().getAllAssociations()) == null) continue;
                        for (int nAssociationIndex = 0; nAssociationIndex < vwAssociations.length; ++nAssociationIndex) {
                            VWBaseAssociationUI associationUI = null;
                            switch (vwAssociations[nAssociationIndex].getTargetType()) {
                                case 1: {
                                    VWBaseStepUI stepUI2 = this.findStep(this.m_map.getMapDefinition().getStep(vwAssociations[nAssociationIndex].getTargetId()));
                                    if (stepUI2 == null) break;
                                    associationUI = new VWBaseAssociationUI(vwAssociations[nAssociationIndex], textAnnotationUI, stepUI2, this.m_stepRouteColors, this.m_workflowPane.getMapAttributes());
                                    textAnnotationUI.addAssociation(associationUI, stepUI2);
                                    stepUI2.addAssociation(associationUI, textAnnotationUI);
                                    break;
                                }
                                case 2: {
                                    routeUI = this.findRoute(vwAssociations[nAssociationIndex].getTargetId());
                                    if (routeUI == null) break;
                                    associationUI = new VWBaseAssociationUI(vwAssociations[nAssociationIndex], textAnnotationUI, routeUI, this.m_stepRouteColors, this.m_workflowPane.getMapAttributes());
                                    textAnnotationUI.addAssociation(associationUI, routeUI);
                                    routeUI.addAssociation(associationUI, textAnnotationUI);
                                    break;
                                }
                            }
                            if (associationUI == null) continue;
                            this.m_associations.addElement(associationUI);
                            newVWItems.addElement(vwAssociations[nAssociationIndex]);
                            this.repaint(associationUI.getBounds());
                            associationUI.addFocusListener(this);
                            associationUI.setSelect(true);
                        }
                    }
                } else {
                    throw new VWException("vw.toolkit.design.mapui.EmptyPasteBuffer", "No items were retrieved from the clipboard.");
                }
                Object[] items = new Object[newVWItems.size()];
                newVWItems.copyInto(items);
                this.notifyOfItemsAdded(items);
                this.notifySelectListeners(true);
                this.recalculateBounds(0);
                Object var16_22 = null;
                this.setCursorMode(0);
            }
            catch (VWException ex) {
                VWDebug.logException(ex);
                VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), VWResource.s_error, 1);
                Object var16_23 = null;
                this.setCursorMode(0);
            }
        }
        catch (Throwable throwable) {
            Object var16_24 = null;
            this.setCursorMode(0);
            throw throwable;
        }
    }
}

